/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.transport;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerHost;
import org.springframework.boot.buildpack.platform.docker.transport.LocalHttpClientTransport;
import org.springframework.boot.buildpack.platform.docker.transport.RemoteHttpClientTransport;
import org.springframework.boot.buildpack.platform.io.IOConsumer;
import org.springframework.boot.buildpack.platform.system.Environment;

public interface HttpTransport {
    public Response get(URI var1) throws IOException;

    public Response post(URI var1) throws IOException;

    public Response post(URI var1, String var2) throws IOException;

    public Response post(URI var1, String var2, IOConsumer<OutputStream> var3) throws IOException;

    public Response put(URI var1, String var2, IOConsumer<OutputStream> var3) throws IOException;

    public Response delete(URI var1) throws IOException;

    public static HttpTransport create() {
        return HttpTransport.create(Environment.SYSTEM);
    }

    public static HttpTransport create(DockerHost dockerHost) {
        return HttpTransport.create(Environment.SYSTEM, dockerHost);
    }

    public static HttpTransport create(Environment environment) {
        return HttpTransport.create(environment, null);
    }

    public static HttpTransport create(Environment environment, DockerHost dockerHost) {
        RemoteHttpClientTransport remote = RemoteHttpClientTransport.createIfPossible(environment, dockerHost);
        return remote != null ? remote : LocalHttpClientTransport.create(environment);
    }

    public static interface Response
    extends Closeable {
        public InputStream getContent() throws IOException;
    }
}

