/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint;

import java.time.Duration;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;

class EndpointIdTimeToLivePropertyFunction
implements Function<EndpointId, Long> {
    private static final Bindable<Duration> DURATION = Bindable.of(Duration.class);
    private final Environment environment;

    EndpointIdTimeToLivePropertyFunction(Environment environment) {
        this.environment = environment;
    }

    @Override
    public @Nullable Long apply(EndpointId endpointId) {
        String name = String.format("management.endpoint.%s.cache.time-to-live", endpointId.toLowerCaseString());
        BindResult duration = Binder.get((Environment)this.environment).bind(name, DURATION);
        return (Long)duration.map(Duration::toMillis).orElse(null);
    }
}

