/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.server;

import org.jspecify.annotations.Nullable;
import org.springframework.core.env.Environment;

public enum ManagementPortType {
    DISABLED,
    SAME,
    DIFFERENT;


    public static ManagementPortType get(Environment environment) {
        Integer managementPort = ManagementPortType.getPortProperty(environment, "management.server.");
        if (managementPort != null && managementPort < 0) {
            return DISABLED;
        }
        Integer serverPort = ManagementPortType.getPortProperty(environment, "server.");
        return managementPort == null || serverPort == null && managementPort.equals(8080) || managementPort != 0 && managementPort.equals(serverPort) ? SAME : DIFFERENT;
    }

    private static @Nullable Integer getPortProperty(Environment environment, String prefix) {
        return (Integer)environment.getProperty(prefix + "port", Integer.class);
    }
}

