/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.model;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxVerificationHelper;
import org.spdx.rdfparser.model.IRdfModel;
import org.spdx.rdfparser.model.RdfModelObject;

public class DoapProject
extends RdfModelObject {
    public static final String UNKNOWN_URI = "UNKNOWN";
    private String name = null;
    private String homePage = null;
    private String uri = null;

    static DoapProject getExistingProject(IModelContainer modelContainer, String projectUrl) throws InvalidSPDXAnalysisException {
        Resource projectResource = modelContainer.getModel().createResource(projectUrl);
        modelContainer.getModel().read(projectUrl);
        return new DoapProject(modelContainer, projectResource.asNode());
    }

    public DoapProject(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        super(modelContainer, node);
        this.getPropertiesFromModel();
    }

    @Override
    public void getPropertiesFromModel() throws InvalidSPDXAnalysisException {
        this.name = this.findSinglePropertyValue("http://usefulinc.com/ns/doap#", "name");
        this.homePage = this.findSinglePropertyValue("http://usefulinc.com/ns/doap#", "homepage");
    }

    public DoapProject(String name, String homePage) {
        this.name = name;
        this.homePage = homePage;
    }

    @Override
    public void populateModel() throws InvalidSPDXAnalysisException {
        this.setPropertyValue("http://usefulinc.com/ns/doap#", "name", this.name);
        this.setPropertyValue("http://usefulinc.com/ns/doap#", "homepage", this.homePage);
    }

    public String getName() {
        if (this.resource != null && this.refreshOnGet) {
            this.name = this.findSinglePropertyValue("http://usefulinc.com/ns/doap#", "name");
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.setPropertyValue("http://usefulinc.com/ns/doap#", "name", name);
    }

    public String getHomePage() {
        if (this.resource != null && this.refreshOnGet) {
            this.homePage = this.findSinglePropertyValue("http://usefulinc.com/ns/doap#", "homepage");
        }
        return this.homePage;
    }

    public void setHomePage(String homePage) {
        this.homePage = homePage;
        this.setPropertyValue("http://usefulinc.com/ns/doap#", "homepage", homePage);
    }

    public String getProjectUri() {
        if (this.resource != null && this.resource.isURIResource()) {
            this.uri = this.resource.getURI();
        }
        return this.uri;
    }

    public void setProjectUri(String uri) throws InvalidSPDXAnalysisException {
        if (this.resource != null && !this.resource.hasURI(uri)) {
            throw new InvalidSPDXAnalysisException("Can not set a URI value for a resource which has already been created.");
        }
        if (!uri.equals(UNKNOWN_URI) && !SpdxVerificationHelper.isValidUri(uri)) {
            throw new InvalidSPDXAnalysisException("Invalid URI for DOAP Project " + this.name + ": " + uri);
        }
        this.uri = uri;
    }

    @Override
    public List<String> verify() {
        ArrayList retval = Lists.newArrayList();
        if (!(this.homePage == null || this.homePage.isEmpty() || this.getHomePage().equals(UNKNOWN_URI) || SpdxVerificationHelper.isValidUri(this.homePage))) {
            retval.add("Invalid project home page - not a URL");
        }
        return retval;
    }

    @Override
    public String getUri(IModelContainer modelContainer) {
        if (this.uri == UNKNOWN_URI) {
            return null;
        }
        return this.uri;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DoapProject)) {
            return false;
        }
        DoapProject compare = (DoapProject)o;
        if (this.resource != null && this.resource.equals((Object)compare.resource)) {
            return true;
        }
        if (compare.getProjectUri() != null && this.getProjectUri() != null && !compare.getProjectUri().equals(UNKNOWN_URI) && !this.getProjectUri().equals(UNKNOWN_URI)) {
            return this.getProjectUri().equals(compare.getProjectUri());
        }
        if (compare.getProjectUri() != null && !compare.getProjectUri().equals(UNKNOWN_URI) || this.getProjectUri() != null && !this.getProjectUri().equals(UNKNOWN_URI)) {
            return false;
        }
        if (compare.getHomePage() != null && this.getHomePage() != null && compare.getName() != null && this.getName() != null) {
            return compare.getHomePage().equals(this.getHomePage()) && compare.getName().equals(this.getName());
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        if (this.getProjectUri() != null && !this.getProjectUri().equals(UNKNOWN_URI)) {
            return this.getProjectUri().hashCode();
        }
        if (this.getHomePage() != null) {
            return this.getHomePage().hashCode();
        }
        return super.hashCode();
    }

    @Override
    public Resource getType(Model model) {
        return model.createResource("http://usefulinc.com/ns/doap#Project");
    }

    public DoapProject clone() {
        DoapProject retval = new DoapProject(this.getName(), this.getHomePage());
        if (this.getProjectUri() != null) {
            try {
                retval.setProjectUri(this.getProjectUri());
            }
            catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
                // empty catch block
            }
        }
        return retval;
    }

    @Override
    public boolean equivalent(IRdfModel compare) {
        if (compare == this) {
            return true;
        }
        if (!(compare instanceof DoapProject)) {
            return false;
        }
        DoapProject comp = (DoapProject)compare;
        return Objects.equal((Object)this.name, (Object)comp.getName()) && Objects.equal((Object)this.homePage, (Object)comp.getHomePage());
    }
}

