/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.sql.Date;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

@UDFType(deterministic=true)
@Description(name="current_date", value="_FUNC_() - Returns the current date at the start of query evaluation. All calls of current_date within the same query return the same value.")
public class GenericUDFCurrentDate
extends GenericUDF {
    protected DateWritable currentDate;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 0) {
            throw new UDFArgumentLengthException("The function CURRENT_DATE does not take any arguments, but found " + arguments.length);
        }
        if (this.currentDate == null) {
            Date dateVal = Date.valueOf(SessionState.get().getQueryCurrentTimestamp().toString().substring(0, 10));
            this.currentDate = new DateWritable(dateVal);
        }
        return PrimitiveObjectInspectorFactory.writableDateObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        return this.currentDate;
    }

    public DateWritable getCurrentDate() {
        return this.currentDate;
    }

    public void setCurrentDate(DateWritable currentDate) {
        this.currentDate = currentDate;
    }

    @Override
    public String getDisplayString(String[] children) {
        return "CURRENT_DATE()";
    }

    @Override
    public void copyToNewInstance(Object newInstance) throws UDFArgumentException {
        super.copyToNewInstance(newInstance);
        GenericUDFCurrentDate other = (GenericUDFCurrentDate)newInstance;
        if (this.currentDate != null) {
            other.currentDate = new DateWritable(this.currentDate);
        }
    }
}

