/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class KeyChange
extends MOMutableColumn {
    public KeyChange(int columnID, MOAccess access, OctetString defaultValue, boolean mutableInService) {
        super(columnID, 4, access, (Variable)defaultValue, mutableInService);
    }

    public static OctetString changeKey(AuthenticationProtocol authProtocol, OctetString oldKey, OctetString keyChange, int keyLength) {
        byte[] random = new byte[keyLength];
        byte[] delta = new byte[keyChange.length() - keyLength];
        System.arraycopy(keyChange.getValue(), 0, random, 0, keyLength);
        System.arraycopy(keyChange.getValue(), keyLength, delta, 0, keyChange.length() - keyLength);
        byte[] newKey = authProtocol.changeDelta(oldKey.getValue(), delta, random);
        return new OctetString(newKey, random.length, newKey.length - random.length);
    }

    @Override
    public void get(SubRequest subRequest, MOTableRow row, int column) {
        if (this.getAccess().isAccessibleForRead()) {
            subRequest.getVariableBinding().setVariable((Variable)new OctetString());
        } else {
            subRequest.getStatus().setErrorStatus(6);
        }
        subRequest.completed();
    }
}

