/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import org.simpleframework.transport.Cursor;
import org.simpleframework.transport.Source;
import org.simpleframework.transport.Transport;
import org.simpleframework.transport.TransportException;
import org.simpleframework.transport.TransportSource;

public class TransportCursor
implements Cursor {
    private Source soure;
    private byte[] buffer;
    private int count;
    private int mark;
    private int pos;
    private int limit;

    public TransportCursor(Transport transport) {
        this(transport, 2048);
    }

    public TransportCursor(Transport transport, int size) {
        this.soure = new TransportSource(transport, size);
        this.buffer = new byte[0];
        this.limit = size;
    }

    public boolean isOpen() throws IOException {
        return this.soure.isOpen();
    }

    public boolean isReady() throws IOException {
        return this.ready() > 0;
    }

    public int ready() throws IOException {
        if (this.count > 0) {
            return this.count;
        }
        return this.soure.ready();
    }

    public int read(byte[] data) throws IOException {
        return this.read(data, 0, data.length);
    }

    public int read(byte[] data, int off, int len) throws IOException {
        if (this.count <= 0) {
            this.mark = this.pos;
            return this.soure.read(data, off, len);
        }
        int size = Math.min(this.count, len);
        if (size > 0) {
            System.arraycopy(this.buffer, this.pos, data, off, size);
            this.mark = this.pos;
            this.pos += size;
            this.count -= size;
        }
        return size;
    }

    public void push(byte[] data) throws IOException {
        this.push(data, 0, data.length);
    }

    public void push(byte[] data, int off, int len) throws IOException {
        int size = this.buffer.length;
        if (size < len + this.count) {
            this.expand(len + this.count);
        }
        int start = this.pos - len;
        if (len > 0) {
            System.arraycopy(data, off, this.buffer, start, len);
            this.mark = start;
            this.pos = start;
            this.count += len;
        }
    }

    private void expand(int capacity) throws IOException {
        if (capacity > this.limit) {
            throw new TransportException("Capacity limit exceeded");
        }
        byte[] temp = new byte[capacity];
        int start = capacity - this.count;
        int shift = this.pos - this.mark;
        if (this.count > 0) {
            System.arraycopy(this.buffer, this.pos, temp, start, this.count);
        }
        this.pos = capacity - this.count;
        this.mark = this.pos - shift;
        this.buffer = temp;
    }

    public int reset(int size) throws IOException {
        if (this.mark == this.pos) {
            return this.soure.reset(size);
        }
        if (this.pos - size < this.mark) {
            size = this.pos - this.mark;
        }
        if (size > 0) {
            this.count += size;
            this.pos -= size;
        }
        return size;
    }
}

