/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.impl;

import java.io.InputStream;
import java.lang.reflect.Type;
import org.simpleflatmapper.ow2asm.AnnotationVisitor;
import org.simpleflatmapper.ow2asm.ClassReader;
import org.simpleflatmapper.ow2asm.ClassVisitor;
import org.simpleflatmapper.ow2asm.TypePath;
import org.simpleflatmapper.reflect.asm.AsmUtils;

public class ImmutableOrgHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Type findImplementation(Class<?> targetClass) {
        ClassLoader cl = targetClass.getClassLoader();
        if (cl == null) {
            return null;
        }
        String fileName = targetClass.getName().replace('.', '/') + ".class";
        InputStream is = cl.getResourceAsStream(fileName);
        if (is == null) {
            return null;
        }
        try {
            ClassReader classReader = new ClassReader(is);
            ImmutableOrgClassVisitor classVisitor = new ImmutableOrgClassVisitor();
            classReader.accept((ClassVisitor)classVisitor, 0);
            if (classVisitor.isImmutable) {
                String name = targetClass.getName();
                int indexOfLastDot = name.lastIndexOf(46);
                String immutablePrefix = classVisitor.getImmutablePrefix();
                String immutableName = indexOfLastDot != -1 ? name.substring(0, indexOfLastDot + 1) + immutablePrefix + name.substring(indexOfLastDot + 1) : immutablePrefix + name;
                ClassLoader classLoader = targetClass.getClassLoader();
                Class<?> clazz = classLoader.loadClass(immutableName);
                return clazz;
            }
        }
        catch (Exception e) {
            Type type = null;
            return type;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    private static class ImmutableOrgClassVisitor
    extends ClassVisitor {
        private boolean isImmutable;
        private String immutablePrefix = "Immutable*";

        public ImmutableOrgClassVisitor() {
            super(AsmUtils.API);
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if ("Lorg/immutables/value/Value$Immutable;".equals(descriptor)) {
                this.isImmutable = true;
            } else if ("Lorg/immutables/value/Value$Style;".equals(descriptor)) {
                return new AnnotationVisitor(AsmUtils.API){

                    public void visit(String name, Object value) {
                        if ("typeImmutable".equals(name)) {
                            immutablePrefix = (String)value;
                        }
                        super.visit(name, value);
                    }

                    public void visitEnum(String name, String descriptor, String value) {
                        super.visitEnum(name, descriptor, value);
                    }

                    public AnnotationVisitor visitAnnotation(String name, String descriptor) {
                        return super.visitAnnotation(name, descriptor);
                    }

                    public AnnotationVisitor visitArray(String name) {
                        return super.visitArray(name);
                    }
                };
            }
            return super.visitAnnotation(descriptor, visible);
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            return super.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
        }

        public String getImmutablePrefix() {
            if (this.immutablePrefix.endsWith("*")) {
                return this.immutablePrefix.substring(0, this.immutablePrefix.length() - 1);
            }
            return this.immutablePrefix;
        }
    }
}

