/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.meta.ConstructorPropertyMeta;
import org.simpleflatmapper.reflect.meta.DisallowSelfReference;
import org.simpleflatmapper.reflect.meta.NonMappedPropertyMeta;
import org.simpleflatmapper.reflect.meta.ObjectClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMatchingScore;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatch;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.SelfPropertyMeta;
import org.simpleflatmapper.reflect.meta.SubPropertyMeta;
import org.simpleflatmapper.reflect.property.EligibleAsNonMappedProperty;
import org.simpleflatmapper.reflect.property.OptionalProperty;
import org.simpleflatmapper.util.BooleanProvider;

final class ObjectPropertyFinder<T>
extends PropertyFinder<T> {
    private final List<InstantiatorDefinition> eligibleInstantiatorDefinitions;
    private final ObjectClassMeta<T> classMeta;
    private final Map<PropertyMeta<?, ?>, PropertyFinder<?>> subPropertyFinders = new HashMap();
    private State state = State.NONE;
    private String selfName;

    ObjectPropertyFinder(ObjectClassMeta<T> classMeta, boolean selfScoreFullName) {
        super(selfScoreFullName);
        this.classMeta = classMeta;
        this.eligibleInstantiatorDefinitions = classMeta.getInstantiatorDefinitions() != null ? new ArrayList<InstantiatorDefinition>(classMeta.getInstantiatorDefinitions()) : null;
    }

    @Override
    public void lookForProperties(PropertyNameMatcher propertyNameMatcher, Object[] properties, PropertyFinder.FoundProperty<T> matchingProperties, PropertyMatchingScore score, boolean allowSelfReference, PropertyFinder.PropertyFinderTransformer propertyFinderTransform, PropertyFinder.TypeAffinityScorer typeAffinityScorer, PropertyFinder.PropertyFilter propertyFilter) {
        SelfPropertyMeta propertyMeta;
        this.lookForConstructor(propertyNameMatcher, properties, matchingProperties, score, propertyFinderTransform, typeAffinityScorer, propertyFilter);
        this.lookForProperty(propertyNameMatcher, properties, matchingProperties, score, propertyFinderTransform, typeAffinityScorer, propertyFilter);
        String propName = propertyNameMatcher.toString();
        if (allowSelfReference && !this.disallowSelfReference(properties) && (this.state == State.NONE || this.state == State.SELF && propName.equals(this.selfName)) && propertyFilter.testProperty(propertyMeta = new SelfPropertyMeta(this.classMeta.getReflectionService(), this.classMeta.getType(), new BooleanProvider(){

            public boolean getBoolean() {
                return ObjectPropertyFinder.this.state != State.PROPERTIES;
            }
        }, properties, propertyNameMatcher.toString(), this.classMeta))) {
            matchingProperties.found(propertyMeta, this.selfPropertySelectionCallback(propName), score.self(this.classMeta, propName), typeAffinityScorer);
        }
        if (ObjectPropertyFinder.isOptionalAndEligibleAsNonMappedProperty(properties)) {
            NonMappedPropertyMeta meta = new NonMappedPropertyMeta(propertyNameMatcher.toString(), this.classMeta.getType(), this.classMeta.getReflectionService(), properties);
            matchingProperties.found(meta, new Runnable(){

                @Override
                public void run() {
                }
            }, score.notMatch(), typeAffinityScorer);
        }
    }

    public static boolean isOptionalAndEligibleAsNonMappedProperty(Object[] properties) {
        return ObjectPropertyFinder.containsProperty(properties, OptionalProperty.class) && ObjectPropertyFinder.containsProperty(properties, EligibleAsNonMappedProperty.class);
    }

    public static boolean containsProperty(Object[] properties, Class<?> propClass) {
        for (Object p : properties) {
            if (!propClass.isAssignableFrom(p.getClass())) continue;
            return true;
        }
        return false;
    }

    private boolean disallowSelfReference(Object[] properties) {
        if (this.classMeta.getNumberOfProperties() <= 1) {
            return false;
        }
        return ObjectPropertyFinder.containsProperty(properties, DisallowSelfReference.class);
    }

    private void lookForConstructor(PropertyNameMatcher propertyNameMatcher, Object[] properties, final PropertyFinder.FoundProperty<T> matchingProperties, PropertyMatchingScore score, PropertyFinder.PropertyFinderTransformer propertyFinderTransformer, PropertyFinder.TypeAffinityScorer typeAffinityScorer, PropertyFinder.PropertyFilter propertyFilter) {
        if (this.classMeta.getConstructorProperties() != null) {
            for (final ConstructorPropertyMeta<T, ?> prop : this.classMeta.getConstructorProperties()) {
                PropertyNameMatch partialMatch;
                String columnName = this.getColumnName(prop);
                PropertyNameMatch matches = propertyNameMatcher.matches(columnName);
                if (matches != null && this.hasConstructorMatching(prop.getParameter()) && propertyFilter.testProperty(prop)) {
                    matchingProperties.found(prop, this.propertiesRemoveNonMatchingCallBack(prop), score.matches(matches), typeAffinityScorer);
                }
                if (!propertyFilter.testPath(prop) || (partialMatch = propertyNameMatcher.partialMatch(columnName)) == null || !this.hasConstructorMatching(prop.getParameter())) continue;
                PropertyNameMatcher subPropMatcher = partialMatch.getLeftOverMatcher();
                this.lookForSubProperty(subPropMatcher, properties, prop, new PropertyFinder.FoundProperty(){

                    public void found(PropertyMeta propertyMeta, Runnable selectionCallback, PropertyMatchingScore score, PropertyFinder.TypeAffinityScorer typeAffinityScorer) {
                        matchingProperties.found(new SubPropertyMeta(ObjectPropertyFinder.this.classMeta.getReflectionService(), prop, propertyMeta), ObjectPropertyFinder.this.propertiesDelegateAndRemoveNonMatchingCallBack(selectionCallback, prop), score, typeAffinityScorer);
                    }
                }, score.matches(partialMatch), propertyFinderTransformer, typeAffinityScorer, propertyFilter);
            }
        }
    }

    private void lookForProperty(PropertyNameMatcher propertyNameMatcher, Object[] properties, final PropertyFinder.FoundProperty<T> matchingProperties, PropertyMatchingScore score, PropertyFinder.PropertyFinderTransformer propertyFinderTransformer, PropertyFinder.TypeAffinityScorer typeAffinityScorer, PropertyFinder.PropertyFilter propertyFilter) {
        for (final PropertyMeta<T, ?> prop : this.classMeta.getProperties()) {
            PropertyNameMatch subPropMatch;
            String columnName = this.hasAlias(properties) ? prop.getName() : this.getColumnName(prop);
            PropertyNameMatch matches = propertyNameMatcher.matches(columnName);
            if (matches != null && propertyFilter.testProperty(prop)) {
                matchingProperties.found(prop, this.propertiesCallBack(), score.matches(matches), typeAffinityScorer);
            }
            if (!propertyFilter.testPath(prop) || (subPropMatch = propertyNameMatcher.partialMatch(columnName)) == null) continue;
            PropertyNameMatcher subPropMatcher = subPropMatch.getLeftOverMatcher();
            this.lookForSubProperty(subPropMatcher, properties, prop, new PropertyFinder.FoundProperty(){

                public void found(PropertyMeta propertyMeta, Runnable selectionCallback, PropertyMatchingScore score, PropertyFinder.TypeAffinityScorer typeAffinityScorer) {
                    matchingProperties.found(new SubPropertyMeta(ObjectPropertyFinder.this.classMeta.getReflectionService(), prop, propertyMeta), ObjectPropertyFinder.this.propertiesDelegateCallBack(selectionCallback), score, typeAffinityScorer);
                }
            }, score.matches(subPropMatch), propertyFinderTransformer, typeAffinityScorer, propertyFilter);
        }
    }

    private boolean hasAlias(Object[] properties) {
        for (Object o : properties) {
            if (!"org.simpleflatmapper.map.property.RenameProperty".equals(o.getClass().getName())) continue;
            return true;
        }
        return false;
    }

    private void lookForSubProperty(PropertyNameMatcher propertyNameMatcher, Object[] properties, final PropertyMeta<T, ?> prop, final PropertyFinder.FoundProperty foundProperty, PropertyMatchingScore score, PropertyFinder.PropertyFinderTransformer propertyFinderTransformer, PropertyFinder.TypeAffinityScorer typeAffinityScorer, PropertyFinder.PropertyFilter propertyFilter) {
        PropertyFinder<?> subPropertyFinder = this.subPropertyFinders.get(prop);
        final PropertyFinder<?> newPropertyFinder = subPropertyFinder == null ? (subPropertyFinder = prop.getPropertyClassMeta().newPropertyFinder()) : null;
        propertyFinderTransformer.apply(subPropertyFinder).lookForProperties(propertyNameMatcher, properties, new PropertyFinder.FoundProperty(){

            public void found(PropertyMeta propertyMeta, Runnable selectionCallback, PropertyMatchingScore score, PropertyFinder.TypeAffinityScorer typeAffinityScorer) {
                if (newPropertyFinder != null) {
                    ObjectPropertyFinder.this.subPropertyFinders.put(prop, newPropertyFinder);
                }
                foundProperty.found(propertyMeta, selectionCallback, score, typeAffinityScorer);
            }
        }, score, false, propertyFinderTransformer, typeAffinityScorer, propertyFilter);
    }

    private String getColumnName(PropertyMeta<T, ?> prop) {
        return this.classMeta.getAlias(prop.getName());
    }

    private void removeNonMatching(Parameter param) {
        ListIterator<InstantiatorDefinition> li = this.eligibleInstantiatorDefinitions.listIterator();
        while (li.hasNext()) {
            InstantiatorDefinition cd = li.next();
            if (cd.hasParam(param)) continue;
            li.remove();
        }
    }

    private boolean hasConstructorMatching(Parameter param) {
        for (InstantiatorDefinition cd : this.eligibleInstantiatorDefinitions) {
            if (!cd.hasParam(param)) continue;
            return true;
        }
        return false;
    }

    private Runnable compose(final Runnable r1, final Runnable r2) {
        return new Runnable(){

            @Override
            public void run() {
                r1.run();
                r2.run();
            }
        };
    }

    private Runnable propertiesDelegateAndRemoveNonMatchingCallBack(Runnable selectionCallback, ConstructorPropertyMeta<T, ?> prop) {
        return this.compose(selectionCallback, this.propertiesRemoveNonMatchingCallBack(prop));
    }

    private Runnable propertiesRemoveNonMatchingCallBack(ConstructorPropertyMeta<T, ?> prop) {
        return this.compose(this.removeNonMatchingCallBack(prop), this.propertiesCallBack());
    }

    private Runnable removeNonMatchingCallBack(final ConstructorPropertyMeta<T, ?> prop) {
        return new Runnable(){

            @Override
            public void run() {
                ObjectPropertyFinder.this.removeNonMatching(prop.getParameter());
            }
        };
    }

    private Runnable propertiesDelegateCallBack(Runnable selectionCallback) {
        return this.compose(selectionCallback, this.propertiesCallBack());
    }

    private Runnable propertiesCallBack() {
        return new Runnable(){

            @Override
            public void run() {
                ObjectPropertyFinder.this.state = State.PROPERTIES;
            }
        };
    }

    private Runnable selfPropertySelectionCallback(final String propName) {
        return new Runnable(){

            @Override
            public void run() {
                ObjectPropertyFinder.this.state = State.SELF;
                ObjectPropertyFinder.this.selfName = propName;
            }
        };
    }

    @Override
    public List<InstantiatorDefinition> getEligibleInstantiatorDefinitions() {
        return this.eligibleInstantiatorDefinitions;
    }

    @Override
    public PropertyFinder<?> getSubPropertyFinder(PropertyMeta<?, ?> owner) {
        return this.subPropertyFinders.get(owner);
    }

    @Override
    public PropertyFinder<?> getOrCreateSubPropertyFinder(SubPropertyMeta<?, ?, ?> subPropertyMeta) {
        PropertyFinder<?> propertyFinder = this.subPropertyFinders.get(subPropertyMeta.getOwnerProperty());
        if (propertyFinder == null) {
            propertyFinder = subPropertyMeta.getSubProperty().getPropertyClassMeta().newPropertyFinder();
            this.subPropertyFinders.put(subPropertyMeta.getOwnerProperty(), propertyFinder);
        }
        return propertyFinder;
    }

    @Override
    public Type getOwnerType() {
        return this.classMeta.getType();
    }

    @Override
    public void manualMatch(PropertyMeta<?, ?> prop) {
        if (prop.isConstructorProperty()) {
            this.removeNonMatching(((ConstructorPropertyMeta)prop).getParameter());
        }
        super.manualMatch(prop);
    }

    static enum State {
        NONE,
        SELF,
        PROPERTIES;

    }
}

