/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.ScoredGetter;
import org.simpleflatmapper.reflect.ScoredSetter;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.getter.GetterHelper;
import org.simpleflatmapper.reflect.instantiator.ExecutableInstantiatorDefinition;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.ObjectClassMeta;
import org.simpleflatmapper.reflect.meta.ObjectPropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.TypeHelper;

public class FastTupleClassMeta<T>
implements ClassMeta<T> {
    private final ClassMeta<T> delegate;
    private final List<InstantiatorDefinition> instantiatorDefinitions;

    public FastTupleClassMeta(Type target, ReflectionService reflectionService) {
        try {
            Class clazz = TypeHelper.toClass((Type)target);
            this.instantiatorDefinitions = new ArrayList<InstantiatorDefinition>();
            this.instantiatorDefinitions.add(new ExecutableInstantiatorDefinition(clazz.getConstructor(new Class[0]), new Parameter[0]));
            ArrayList<PropertyMeta<T, ?>> properties = FastTupleClassMeta.getPropertyMetas(target, reflectionService);
            this.delegate = new ObjectClassMeta(target, this.instantiatorDefinitions, Collections.emptyList(), Collections.emptyMap(), properties, reflectionService, false);
        }
        catch (NoSuchMethodException e) {
            ErrorHelper.rethrow((Throwable)e);
            throw new IllegalStateException();
        }
    }

    private static <T> ArrayList<PropertyMeta<T, ?>> getPropertyMetas(Type ownerType, ReflectionService reflectionService) throws NoSuchMethodException {
        ArrayList propertyMetas = new ArrayList();
        Class clazz = TypeHelper.toClass((Type)ownerType);
        if (FastTupleClassMeta.isDirect(clazz)) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (m.getParameterTypes().length != 0 || !GetterHelper.isPublicMember(m.getModifiers())) continue;
                String field = m.getName();
                Method setter = clazz.getDeclaredMethod(field, m.getReturnType());
                ObjectPropertyMeta propertyMeta = FastTupleClassMeta.newPropertyMethod(field, m, setter, reflectionService, ownerType);
                propertyMetas.add(propertyMeta);
            }
        } else {
            for (Field f : clazz.getDeclaredFields()) {
                String field = f.getName();
                try {
                    Method getter = clazz.getDeclaredMethod(field, new Class[0]);
                    Method setter = clazz.getDeclaredMethod(field, f.getType());
                    ObjectPropertyMeta propertyMeta = FastTupleClassMeta.newPropertyMethod(field, getter, setter, reflectionService, ownerType);
                    propertyMetas.add(propertyMeta);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        return propertyMetas;
    }

    private static boolean isDirect(Class<?> clazz) {
        try {
            Field unsafe = clazz.getDeclaredField("unsafe");
            int m = unsafe.getModifiers();
            return Modifier.isStatic(m);
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    private static <T, P> ObjectPropertyMeta<T, P> newPropertyMethod(String field, Method getter, Method setter, ReflectionService reflectionService, Type ownerType) {
        Getter methodGetter = reflectionService.getObjectGetterFactory().getMethodGetter(getter);
        Setter methodSetter = reflectionService.getObjectSetterFactory().getMethodSetter(setter);
        return new ObjectPropertyMeta(field, ownerType, reflectionService, getter.getGenericReturnType(), ScoredGetter.of(methodGetter, 1), ScoredSetter.of(methodSetter, 1), null);
    }

    @Override
    public ReflectionService getReflectionService() {
        return this.delegate.getReflectionService();
    }

    @Override
    public PropertyFinder<T> newPropertyFinder(Predicate<PropertyMeta<?, ?>> propertyFilter) {
        return this.delegate.newPropertyFinder(propertyFilter);
    }

    @Override
    public Type getType() {
        return this.delegate.getType();
    }

    @Override
    public List<InstantiatorDefinition> getInstantiatorDefinitions() {
        return this.instantiatorDefinitions;
    }

    @Override
    public void forEachProperties(Consumer<? super PropertyMeta<T, ?>> consumer) {
        this.delegate.forEachProperties(consumer);
    }

    @Override
    public int getNumberOfProperties() {
        return this.delegate.getNumberOfProperties();
    }

    @Override
    public boolean needTransformer() {
        return false;
    }
}

