/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.SourceFieldMapper;
import org.simpleflatmapper.util.Enumerable;
import org.simpleflatmapper.util.ErrorHelper;

public class JoinMapperEnumerable<S, T>
implements Enumerable<T> {
    private final SourceFieldMapper<S, T> mapper;
    private final MappingContext<? super S> mappingContext;
    private final Enumerable<S> sourceEnumerable;
    private T currentValue;
    private T nextValue;

    public JoinMapperEnumerable(SourceFieldMapper<S, T> mapper, MappingContext<? super S> mappingContext, Enumerable<S> sourceEnumerable) {
        this.mapper = mapper;
        this.mappingContext = mappingContext;
        this.sourceEnumerable = sourceEnumerable;
    }

    public boolean next() {
        try {
            this.currentValue = this.nextValue;
            this.nextValue = null;
            while (this.sourceEnumerable.next()) {
                Object source = this.sourceEnumerable.currentValue();
                if (this.mappingContext.broke(source)) {
                    if (this.currentValue == null) {
                        this.currentValue = this.mapper.map((S)source, this.mappingContext);
                        continue;
                    }
                    this.nextValue = this.mapper.map((S)source, this.mappingContext);
                    return true;
                }
                this.mapper.mapTo((S)source, this.currentValue, this.mappingContext);
            }
            return this.currentValue != null;
        }
        catch (Exception e) {
            ErrorHelper.rethrow((Throwable)e);
            return false;
        }
    }

    public T currentValue() {
        return this.currentValue;
    }

    public String toString() {
        return "JoinJdbcMapper{jdbcMapper=" + this.mapper + '}';
    }
}

