/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.converter;

import java.sql.Blob;
import java.sql.SQLException;
import org.simpleflatmapper.converter.Context;
import org.simpleflatmapper.converter.ContextualConverter;

public class BlobToByteConverter
implements ContextualConverter<Blob, byte[]> {
    public byte[] convert(Blob in, Context context) throws Exception {
        if (in != null) {
            long length = in.length();
            if (length > Integer.MAX_VALUE) {
                throw new SQLException("Blob is too big to fit in an byte array length " + in.length());
            }
            return in.getBytes(0L, (int)length);
        }
        return null;
    }
}

