/* *##%
 * Copyright (c) 2009 ruchaud. All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *##%*/

package org.sharengo.wikitty.multistorage;

import java.util.ArrayList;
import java.util.List;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.WikittyExtensionStorage;
import org.sharengo.wikitty.WikittyStorage;

/**
 *
 * @author ruchaud
 * @version $Revision: 1 $
 *
 * Last update: $Date: 2010-04-16 10:29:38 +0200 (ven., 16 avril 2010) $
 * by : $Author: echatellier $
 */
public abstract class MultiStorageConfiguration {

    protected List<WikittyExtensionStorage> extensionStorageMasters;
    protected List<WikittyExtensionStorage> extensionStorageReplications;

    protected List<WikittyStorage> wikittyStorageMasters;
    protected List<WikittyStorage> wikittyStorageReplications;

    public MultiStorageConfiguration() {
        extensionStorageMasters = new ArrayList<WikittyExtensionStorage>();
        extensionStorageReplications = new ArrayList<WikittyExtensionStorage>();

        wikittyStorageMasters = new ArrayList<WikittyStorage>();
        wikittyStorageReplications = new ArrayList<WikittyStorage>();
    }

    public void addExtensionStorage(WikittyExtensionStorage storage, boolean master) {
        if(master) {
            extensionStorageMasters.add(storage);
        } else {
            extensionStorageReplications.add(storage);
        }
    }

    public void addWikittyStorage(WikittyStorage storage, boolean master) {
        if(master) {
            wikittyStorageMasters.add(storage);
        } else {
            wikittyStorageReplications.add(storage);
        }
    }

    public List<WikittyExtensionStorage> getExtensionStorageMasters() {
        return extensionStorageMasters;
    }

    public void setExtensionStorageMasters(List<WikittyExtensionStorage> extensionStorageMasters) {
        this.extensionStorageMasters = extensionStorageMasters;
    }

    public List<WikittyExtensionStorage> getExtensionStorageReplications() {
        return extensionStorageReplications;
    }

    public void setExtensionStorageReplications(List<WikittyExtensionStorage> extensionStorageReplications) {
        this.extensionStorageReplications = extensionStorageReplications;
    }

    public List<WikittyStorage> getWikittyStorageMasters() {
        return wikittyStorageMasters;
    }

    public void setWikittyStorageMasters(List<WikittyStorage> wikittyStorageMasters) {
        this.wikittyStorageMasters = wikittyStorageMasters;
    }

    public List<WikittyStorage> getWikittyStorageReplications() {
        return wikittyStorageReplications;
    }

    public void setWikittyStorageReplications(List<WikittyStorage> wikittyStorageReplications) {
        this.wikittyStorageReplications = wikittyStorageReplications;
    }

    public abstract WikittyExtensionStorage getCurrentMasterExtensionStorage();
    public abstract WikittyStorage getCurrentMasterWikittyStorage();

    public static class BasicConfiguration extends MultiStorageConfiguration {

        @Override
        public WikittyExtensionStorage getCurrentMasterExtensionStorage() {
            if(!extensionStorageMasters.isEmpty()) {
                return extensionStorageMasters.get(0);
            } else {
                throw new WikittyException("No master extension storage available");
            }
        }

        @Override
        public WikittyStorage getCurrentMasterWikittyStorage() {
            if(!wikittyStorageMasters.isEmpty()) {
                return wikittyStorageMasters.get(0);
            } else {
                throw new WikittyException("No master wikitty storage available");
            }
        }
    }
}
