/* *##%
 * Copyright (c) 2009 ruchaud. All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *##%*/
package org.sharengo.wikitty.jpa;

import javax.sql.DataSource;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitPostProcessor;
import org.springframework.beans.factory.annotation.Required;

/**
 * the {@link JtaPersistenceUnitPostProcessor} enables us to define the JTA capable datasource
 * which should be used by the JPA provider directly as a reference within the Spring configuration
 * file.
 *
 * @author ruchaud
 * @version $Revision: 1 $
 *
 * Last update: $Date: 2010-04-16 10:29:38 +0200 (ven., 16 avril 2010) $
 * by : $Author: echatellier $
 */
public class JtaPersistenceUnitPostProcessor implements PersistenceUnitPostProcessor {

    /**
     * a reference to the JTA capable datasource which is add to the PersistenceUnitInfo during post
     * processing instead of beeing specified using the "jta-data-source" setting in the persistence.xml
     * configuration file
     */
    private DataSource jtaDataSource;

    /**
     * enrich the PersistenceUnitInfo read from the persistence.xml configuration file with a reference
     * to the jtaDataSource injected via the Spring configuration. the JTA capable datasource is then
     * used by the LocalContainerEntityManagerFactoryBean to create the EntityManagerFactory
     *
     * @see PersistenceUnitPostProcessor#postProcessPersistenceUnitInfo(MutablePersistenceUnitInfo)
     */
    @Override
    public void postProcessPersistenceUnitInfo(MutablePersistenceUnitInfo mutablePersistenceUnitInfo) {
        mutablePersistenceUnitInfo.setJtaDataSource(getJtaDataSource());
    }

    /**
     * getter for jtaDataSource
     *
     * @return the JTA capable datasource supplied via the setter
     */
    public DataSource getJtaDataSource() {
        return jtaDataSource;
    }

    /**
     * setter for jtaDataSource
     *
     * @param jtaDataSource the JTA capable datasource added to the PersistenceUnitInfo during post processing
     */
    @Required
    public void setJtaDataSource(DataSource jtaDataSource) {
        this.jtaDataSource = jtaDataSource;
    }
}
