/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugengo.generator.spring;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelDependency;
import org.nuiton.eugengo.EugengoUtils;
import org.nuiton.eugengo.generator.ServiceAbstractGenerator;
import org.nuiton.eugengo.generator.WikengoCommonGenerator;

public class ServicesXmlGenerator
extends WikengoCommonGenerator {
    public String getFilenameForModel(ObjectModel model) {
        String modelName = EugengoUtils.extractModelName((Model)model);
        String fileName = "META-INF" + File.separatorChar + "spring" + File.separatorChar + modelName + File.separatorChar + "layer-services.xml";
        return fileName;
    }

    public void generateFromModel(Writer output, ObjectModel model) throws IOException {
        output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        output.write("\n");
        output.write("<beans xmlns=\"http://www.springframework.org/schema/beans\"\n");
        output.write("    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        output.write("    xmlns:aop=\"http://www.springframework.org/schema/aop\"\n");
        output.write("    xmlns:tx=\"http://www.springframework.org/schema/tx\"\n");
        output.write("    xmlns:jee=\"http://www.springframework.org/schema/jee\"\n");
        output.write("    xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-2.0.xsd\n");
        output.write("           http://www.springframework.org/schema/aop http://www.springframework.org/schema/aop/spring-aop-2.0.xsd\n");
        output.write("           http://www.springframework.org/schema/tx http://www.springframework.org/schema/tx/spring-tx-2.0.xsd\n");
        output.write("           http://www.springframework.org/schema/jee http://www.springframework.org/schema/jee/spring-jee-2.0.xsd\">\n");
        output.write("\n");
        output.write("");
        for (ObjectModelClass clazz : model.getClasses()) {
            if (!EugengoUtils.isService((ObjectModelClassifier)clazz)) continue;
            String name = clazz.getName();
            String iocName = EugengoUtils.toLowerCaseFirstLetter((String)name);
            String defaultImpl = ServiceAbstractGenerator.getQualifiedName((ObjectModelClassifier)clazz);
            output.write("    <bean id=\"" + iocName + "\" class=\"" + defaultImpl + "\">\n");
            output.write("");
            for (ObjectModelDependency dep : clazz.getDependencies()) {
                ObjectModelClassifier supplier = dep.getSupplier();
                if (supplier == null || !EugengoUtils.isService(supplier)) continue;
                String supplierVarName = EugengoUtils.toLowerCaseFirstLetter((String)supplier.getName());
                output.write("        <property name=\"" + supplierVarName + "\" ref=\"" + supplierVarName + "\"/>\n");
                output.write("");
            }
            output.write("    </bean>\n");
            output.write("\n");
            output.write("    <tx:advice id=\"txAdvice" + name + "\" transaction-manager=\"transactionManager\">\n");
            output.write("        <tx:attributes>\n");
            output.write("            <tx:method name=\"*\" read-only=\"false\"/>\n");
            output.write("        </tx:attributes>\n");
            output.write("    </tx:advice>\n");
            output.write("    <aop:config>\n");
            output.write("        <aop:advisor pointcut=\"execution(* " + defaultImpl + ".*(..))\" advice-ref=\"txAdvice" + name + "\" />\n");
            output.write("    </aop:config>\n");
            output.write("\n");
            output.write("");
        }
        output.write("</beans>\n");
        output.write("");
    }
}

