/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugengo.generator.spring;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugengo.EugengoUtils;
import org.nuiton.eugengo.generator.WikengoCommonGenerator;

public class ComponentXmlGenerator
extends WikengoCommonGenerator {
    public String getFilenameForModel(ObjectModel model) {
        String fileName = "META-INF" + File.separatorChar + "spring" + File.separatorChar + "component-generated.xml";
        return fileName;
    }

    public void generateFromModel(Writer output, ObjectModel model) throws IOException {
        String modelName = EugengoUtils.extractModelName((Model)model);
        output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        output.write("\n");
        output.write("<beans xmlns=\"http://www.springframework.org/schema/beans\"\n");
        output.write("    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        output.write("    xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-2.0.xsd\">\n");
        output.write("\n");
        output.write("    <!-- this project's specific files -->\n");
        output.write("    <import resource=\"classpath:META-INF/spring/" + modelName + "/layer-hessian-services.xml\"/>\n");
        output.write("    <import resource=\"classpath:META-INF/spring/" + modelName + "/layer-services.xml\"/>\n");
        output.write("    <import resource=\"classpath:META-INF/spring/" + modelName + "/layer-daos-hibernate.xml\"/>\n");
        output.write("\n");
        output.write("    <!-- shared files -->\n");
        output.write("    <import resource=\"classpath:META-INF/spring/layer-hibernate.xml\"/>\n");
        output.write("\n");
        output.write("</beans>\n");
        output.write("");
    }
}

