/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugengo.generator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.Generator;
import org.nuiton.eugene.ObjectModelGenerator;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugengo.generator.BusinessEntityGenerator;
import org.nuiton.eugengo.generator.DaoAbstractGenerator;
import org.nuiton.eugengo.generator.DaoGenerator;
import org.nuiton.eugengo.generator.DtoGenerator;
import org.nuiton.eugengo.generator.EntityGenerator;
import org.nuiton.eugengo.generator.EntityHibernateXmlGenerator;
import org.nuiton.eugengo.generator.EnumGenerator;
import org.nuiton.eugengo.generator.ExceptionGenerator;
import org.nuiton.eugengo.generator.InterfaceGenerator;
import org.nuiton.eugengo.generator.ServiceGenerator;
import org.nuiton.eugengo.generator.ServiceRemoteGenerator;
import org.nuiton.eugengo.generator.WikengoCommonGenerator;
import org.nuiton.eugengo.generator.spring.HessianXmlGenerator;
import org.nuiton.eugengo.generator.test.ServiceTestGenerator;
import org.nuiton.util.Resource;

public class WikengoMetaGenerator
extends ObjectModelGenerator {
    protected static Log log = LogFactory.getLog(WikengoMetaGenerator.class);
    protected static final List<Class<? extends WikengoCommonGenerator>> DEFAULT_GENERATORS = Collections.unmodifiableList(Arrays.asList(InterfaceGenerator.class, ServiceGenerator.class, ServiceTestGenerator.class, ServiceRemoteGenerator.class, HessianXmlGenerator.class, DaoGenerator.class, DaoAbstractGenerator.class, EntityGenerator.class, EntityHibernateXmlGenerator.class, DtoGenerator.class, BusinessEntityGenerator.class, EnumGenerator.class, ExceptionGenerator.class));

    protected List<Class<? extends WikengoCommonGenerator>> getGenerators() {
        List<Class<? extends WikengoCommonGenerator>> result = DEFAULT_GENERATORS;
        Properties props = null;
        try {
            Properties tmpProperties = Resource.getConfigProperties((String)"WikengoMetaGenerator.properties");
            props = new Properties();
            Enumeration<?> e = tmpProperties.propertyNames();
            while (e.hasMoreElements()) {
                String key = e.nextElement() + "";
                String value = tmpProperties.getProperty(key);
                props.setProperty(key, value);
            }
        }
        catch (IOException ioe) {
            log.error((Object)("Unable to load file WikengoMetaGenerator.properties : " + ioe.getMessage()));
        }
        if (props != null) {
            ArrayList<Class<? extends WikengoCommonGenerator>> propsGenerators = new ArrayList<Class<? extends WikengoCommonGenerator>>();
            String basePackage = props.getProperty("basePackage");
            String suffix = props.getProperty("suffix");
            if (basePackage != null && !basePackage.endsWith(".")) {
                basePackage = basePackage + ".";
            }
            for (Object key : props.keySet()) {
                Class<? extends WikengoCommonGenerator> clazz;
                String className = (String)key;
                if (suffix != null) {
                    className = className + suffix;
                }
                if ((clazz = this.getClass(className)) == null && basePackage != null) {
                    clazz = this.getClass(basePackage + className);
                }
                if (clazz != null) {
                    propsGenerators.add(clazz);
                    continue;
                }
                log.warn((Object)("No generator found for property '" + className + "'"));
            }
            if (!propsGenerators.isEmpty()) {
                result = propsGenerators;
            }
        }
        log.warn((Object)("Enabled generators: " + result));
        return result;
    }

    protected Class<? extends WikengoCommonGenerator> getClass(String className) {
        Class<?> result = null;
        try {
            Class<?> clazz = Class.forName(className);
            if (WikengoCommonGenerator.class.isAssignableFrom(clazz)) {
                result = clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public void generate(ObjectModel model, File destDir) throws IOException {
        for (Class<? extends WikengoCommonGenerator> generatorClass : this.getGenerators()) {
            ObjectModelGenerator generator;
            if (this.excludeTemplates != null && this.excludeTemplates.contains(generatorClass.getName())) {
                log.info((Object)("exclude generator " + generatorClass));
                continue;
            }
            try {
                generator = generatorClass.newInstance();
                generator.setParent((Generator)this);
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"An error occurs when generating persistence", (Throwable)e);
                }
                throw new RuntimeException(e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("call template : " + generatorClass.getSimpleName()));
            }
            generator.generate(model, destDir);
        }
    }
}

