/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugengo.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelDependency;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugengo.EugengoUtils;
import org.nuiton.eugengo.generator.WikengoCommonGenerator;

public class ServiceRemoteGenerator
extends WikengoCommonGenerator {
    private static final Log log = LogFactory.getLog(ServiceRemoteGenerator.class);

    public String getFilenameForClass(ObjectModelClass clazz) {
        String fqn = ServiceRemoteGenerator.getQualifiedName(clazz);
        return fqn.replace('.', File.separatorChar) + ".java";
    }

    public static String getQualifiedName(ObjectModelClass clazz) {
        return ServiceRemoteGenerator.getPackageName(clazz) + "." + ServiceRemoteGenerator.getClassName(clazz);
    }

    public static String getPackageName(ObjectModelClass clazz) {
        return clazz.getPackageName();
    }

    public static String getClassName(ObjectModelClass clazz) {
        return clazz.getName() + "WebService";
    }

    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!EugengoUtils.isWebService((ObjectModelClassifier)clazz)) {
            return;
        }
        boolean isCrud = EugengoUtils.isCrudService((ObjectModelClassifier)clazz);
        String crudDtoFqn = null;
        if (isCrud) {
            ObjectModelClassifier dto = null;
            for (ObjectModelDependency dependency : clazz.getDependencies()) {
                if (dependency.getSupplier() == null || !EugengoUtils.isDto(dependency.getSupplier())) continue;
                dto = dependency.getSupplier();
            }
            if (dto == null) {
                log.error((Object)("missing dto dependency: " + clazz.getQualifiedName()));
                return;
            }
            crudDtoFqn = dto.getQualifiedName();
        }
        this.generateCopyright(output);
        String packageName = ServiceRemoteGenerator.getPackageName(clazz);
        String name = ServiceRemoteGenerator.getClassName(clazz);
        output.write("package " + packageName + ";\n");
        output.write("\n");
        output.write("");
        String technicalExceptionClass = "org.sharengo.exceptions.TechnicalException";
        this.clearImports();
        if (isCrud) {
            this.addImport("org.sharengo.utils.utils.services.ICrudSrv");
            this.addImport(crudDtoFqn);
        }
        this.addImport(technicalExceptionClass);
        this.lookForOperationImports((ObjectModelClassifier)clazz);
        this.generateImports(output, packageName);
        String crudExtension = "";
        if (isCrud) {
            crudExtension = "extends ICrudSrv<" + this.getType(crudDtoFqn) + "> ";
        }
        this.generateClazzDocumentation(output, (ObjectModelClassifier)clazz, new String[0]);
        output.write("public interface " + name + " " + crudExtension + "{\n");
        output.write("\n");
        output.write("");
        for (ObjectModelOperation op : clazz.getOperations()) {
            if (!EugengoUtils.isRemote(op)) continue;
            this.generateOperationHeader(output, op, true, technicalExceptionClass);
        }
        output.write("} //" + name + "\n");
        output.write("");
    }
}

