/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugengo.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelDependency;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugengo.EugengoUtils;
import org.nuiton.eugengo.generator.WikengoCommonGenerator;

public class ServiceGenerator
extends WikengoCommonGenerator {
    private static final Log log = LogFactory.getLog(ServiceGenerator.class);

    public String getFilenameForClassifier(ObjectModelClassifier clazz) {
        String fqn = ServiceGenerator.getQualifiedName(clazz);
        return fqn.replace('.', File.separatorChar) + ".java";
    }

    public static String getQualifiedName(ObjectModelClassifier clazz) {
        return ServiceGenerator.getPackageName(clazz) + "." + ServiceGenerator.getClassName(clazz);
    }

    public static String getPackageName(ObjectModelClassifier clazz) {
        return clazz.getPackageName();
    }

    public static String getClassName(ObjectModelClassifier clazz) {
        return clazz.getName();
    }

    public void generateFromClassifier(Writer output, ObjectModelClassifier clazz) throws IOException {
        if (!EugengoUtils.isService(clazz)) {
            return;
        }
        boolean isCrud = EugengoUtils.isCrudService(clazz);
        String crudDtoFqn = null;
        if (isCrud) {
            ObjectModelClassifier dto = null;
            for (ObjectModelDependency dependency : clazz.getDependencies()) {
                if (dependency.getSupplier() == null || !EugengoUtils.isDto(dependency.getSupplier())) continue;
                dto = dependency.getSupplier();
            }
            if (dto == null) {
                log.error((Object)("missing dto dependency: " + clazz.getQualifiedName()));
                return;
            }
            crudDtoFqn = dto.getQualifiedName();
        }
        this.generateCopyright(output);
        String packageName = clazz.getPackageName();
        String name = clazz.getName();
        output.write("package " + packageName + ";\n");
        output.write("\n");
        output.write("");
        String technicalExceptionClass = "org.sharengo.exceptions.TechnicalException";
        this.clearImports();
        if (isCrud) {
            this.addImport("org.sharengo.utils.utils.services.ICrudSrv");
            this.addImport(crudDtoFqn);
        }
        if (clazz instanceof ObjectModelClass) {
            this.lookForStaticAttributeImports((ObjectModelClass)clazz);
        }
        this.lookForOperationImports(clazz);
        this.addImport(technicalExceptionClass);
        this.generateImports(output, packageName);
        String crudExtension = "";
        if (isCrud) {
            crudExtension = "extends ICrudSrv<" + this.getType(crudDtoFqn) + "> ";
        }
        this.generateClazzDocumentation(output, clazz, new String[0]);
        output.write("public interface " + name + " " + crudExtension + "{\n");
        output.write("\n");
        output.write("");
        if (clazz instanceof ObjectModelClass) {
            this.generateStaticAttributes(output, (ObjectModelClass)clazz);
        }
        for (ObjectModelOperation op : clazz.getOperations()) {
            this.generateOperationHeader(output, op, true, technicalExceptionClass);
        }
        output.write("} //" + name + "\n");
        output.write("");
    }
}

