/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugengo.generator;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelDependency;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugengo.EugengoUtils;
import org.nuiton.eugengo.generator.WikengoCommonGenerator;

public class ServiceAbstractGenerator
extends WikengoCommonGenerator {
    private static final Log log = LogFactory.getLog(ServiceAbstractGenerator.class);

    public String getFilenameForClassifier(ObjectModelClassifier clazz) {
        String fqn = ServiceAbstractGenerator.getQualifiedName(clazz);
        return fqn.replace('.', File.separatorChar) + ".java";
    }

    public static String getQualifiedName(ObjectModelClassifier clazz) {
        return ServiceAbstractGenerator.getPackageName(clazz) + "." + ServiceAbstractGenerator.getClassName(clazz);
    }

    private static String getClassName(ObjectModelClassifier clazz) {
        return "Abstract" + clazz.getName();
    }

    private static String getPackageName(ObjectModelClassifier clazz) {
        return clazz.getPackageName() + ".impl";
    }

    public void generateFromClassifier(Writer output, ObjectModelClassifier clazz) throws IOException {
        if (!EugengoUtils.isService(clazz)) {
            return;
        }
        boolean isCrud = EugengoUtils.isCrudService(clazz);
        String crudDtoFqn = null;
        String crudEntityFqn = null;
        if (isCrud) {
            ObjectModelClassifier dto = null;
            ObjectModelClassifier entity = null;
            for (ObjectModelDependency dependency : clazz.getDependencies()) {
                ObjectModelClassifier supplier = dependency.getSupplier();
                if (supplier != null && EugengoUtils.isDto(supplier)) {
                    dto = supplier;
                }
                if (supplier == null || !EugengoUtils.isEntity(supplier)) continue;
                entity = supplier;
            }
            if (dto == null) {
                log.error((Object)("missing dto dependency: " + clazz.getQualifiedName()));
                return;
            }
            if (entity == null) {
                log.error((Object)("missing entity dependency: " + clazz.getQualifiedName()));
                return;
            }
            crudDtoFqn = dto.getQualifiedName();
            crudEntityFqn = entity.getQualifiedName();
        }
        this.generateCopyright(output);
        String packageName = ServiceAbstractGenerator.getPackageName(clazz);
        String name = ServiceAbstractGenerator.getClassName(clazz);
        String parentInterface = clazz.getQualifiedName();
        output.write("package " + packageName + ";\n");
        output.write("\n");
        output.write("");
        String technicalExceptionClass = "org.sharengo.exceptions.TechnicalException";
        this.clearImports();
        this.addImport(technicalExceptionClass);
        if (isCrud) {
            this.addImport("org.sharengo.orm.DAO");
            this.addImport("org.sharengo.utils.utils.exceptions.EmptyParameterException");
            this.addImport("org.sharengo.utils.utils.exceptions.NullParameterException");
            this.addImport("org.sharengo.utils.utils.services.impl.AbstractCrudSrv");
            this.addImport(crudDtoFqn);
            this.addImport(crudEntityFqn);
            this.addImport(Serializable.class);
            this.addImport(Log.class);
            this.addImport(LogFactory.class);
        }
        this.lookForIocImports(clazz);
        if (clazz instanceof ObjectModelClass) {
            this.lookForAttributeImports((ObjectModelClass)clazz);
        }
        this.lookForOperationImports(clazz);
        this.addImport(parentInterface);
        this.generateImports(output, packageName);
        String extension = "implements " + this.getType(parentInterface);
        if (isCrud) {
            extension = "extends AbstractCrudSrv<" + this.getType(crudDtoFqn) + ", " + this.getType(crudEntityFqn) + "> " + extension;
        }
        this.generateClazzDocumentation(output, clazz, new String[0]);
        output.write("public abstract class " + name + " " + extension + " {\n");
        output.write("\n");
        output.write("");
        if (isCrud) {
            output.write("    private final static Log log = LogFactory.getLog(" + name + ".class);\n");
            output.write("\n");
            output.write("");
        }
        for (ObjectModelDependency dep : clazz.getDependencies()) {
            ObjectModelClassifier supplier = dep.getSupplier();
            if (supplier == null || !EugengoUtils.isService(supplier)) continue;
            this.generateIocDependency(output, dep);
        }
        if (clazz instanceof ObjectModelClass) {
            this.generateAttributesDeclaration(output, (ObjectModelClass)clazz);
        }
        if (isCrud) {
            String dtoType = this.getType(crudDtoFqn);
            String entityType = this.getType(crudEntityFqn);
            String predictedDaoName = EugengoUtils.toLowerCaseFirstLetter((String)entityType) + "Dao";
            output.write("    protected " + dtoType + " convertToDto(" + entityType + " entity) {\n");
            output.write("        return null;\n");
            output.write("    }\n");
            output.write("\n");
            output.write("    protected void convertToEntity(" + dtoType + " dto,\n");
            output.write("            " + entityType + " entity) {\n");
            output.write("    }\n");
            output.write("\n");
            output.write("    protected " + entityType + " createEntity() {\n");
            output.write("        //return new " + entityType + "();\n");
            output.write("        return null;\n");
            output.write("    }\n");
            output.write("\n");
            output.write("    protected DAO<" + entityType + "> getDao() {\n");
            output.write("        //return " + predictedDaoName + ";\n");
            output.write("        return null;\n");
            output.write("    }\n");
            output.write("\n");
            output.write("    protected Serializable getIdFromDto(" + dtoType + " dto) {\n");
            output.write("        //return dto.getId();\n");
            output.write("        return null;\n");
            output.write("    }\n");
            output.write("\n");
            output.write("    protected Log getLog() {\n");
            output.write("        return log;\n");
            output.write("    }\n");
            output.write("\n");
            output.write("    protected void validateDto(" + dtoType + " dto)\n");
            output.write("            throws EmptyParameterException, NullParameterException {\n");
            output.write("    }\n");
            output.write("\n");
            output.write("");
        }
        for (ObjectModelOperation op : clazz.getOperations()) {
            this.generateOperationHeader(output, op, false, technicalExceptionClass);
            String opName = op.getName();
            output.write("        throw new UnsupportedOperationException(\"" + name + "#" + opName + "\");\n");
            output.write("    }\n");
            output.write("\n");
            output.write("");
        }
        output.write("} //" + name + "\n");
        output.write("");
    }
}

