/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugengo.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugengo.EugengoUtils;
import org.nuiton.eugengo.generator.ServiceRemoteGenerator;
import org.nuiton.eugengo.generator.WikengoCommonGenerator;

public class HessianClientFactoryGenerator
extends WikengoCommonGenerator {
    public String getFilenameForModel(ObjectModel model) {
        String fqn = this.getPackageName() + File.separatorChar + this.getClassName();
        return fqn.replace('.', File.separatorChar) + ".java";
    }

    protected String getPackageName() {
        String modelName = EugengoUtils.extractModelName((Model)this.model);
        String result = modelName + ".ws";
        return result;
    }

    protected String getClassName() {
        return "WSHessianClientFactory";
    }

    public void generateFromModel(Writer output, ObjectModel model) throws IOException {
        String wsType;
        this.generateCopyright(output);
        String packageName = this.getPackageName();
        String name = this.getClassName();
        output.write("package " + packageName + ";\n");
        output.write("\n");
        output.write("");
        this.clearImports();
        ArrayList<String> wsTypes = new ArrayList<String>();
        for (ObjectModelClass clazz : model.getClasses()) {
            if (!EugengoUtils.isWebService((ObjectModelClassifier)clazz)) continue;
            wsType = ServiceRemoteGenerator.getQualifiedName(clazz);
            this.addImport(wsType);
            wsTypes.add(wsType);
        }
        if (!wsTypes.isEmpty()) {
            this.addImport(MalformedURLException.class);
            this.addImport("com.caucho.hessian.client.HessianProxyFactory");
        }
        this.addImport(Logger.class);
        this.addImport(Level.class);
        this.generateImports(output, packageName);
        output.write("public class WSHessianClientFactory {\n");
        output.write("\n");
        output.write("    private static WSHessianClientFactory instance = new WSHessianClientFactory();\n");
        output.write("\n");
        output.write("    static {\n");
        output.write("        Logger.getLogger(\"com.caucho.hessian\").setLevel(Level.SEVERE);\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    private WSHessianClientFactory() {\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    public static WSHessianClientFactory getInstance() {\n");
        output.write("        return instance;\n");
        output.write("    }\n");
        output.write("\n");
        output.write("");
        for (String wsFqn : wsTypes) {
            String wsName = wsType = this.getType(wsFqn);
            output.write("    /**\n");
            output.write("     * Create a webservice proxy for \"" + wsName + "\"\n");
            output.write("     * @param address the base adress used to bind service\n");
            output.write("     * @return the created proxy to the service\n");
            output.write("     * @throws MalformedURLException in case <param>address</param> is invalid\n");
            output.write("     */\n");
            output.write("    public " + wsType + " create" + wsName + "(\n");
            output.write("            String address) throws MalformedURLException {\n");
            output.write("        //Create stub factory\n");
            output.write("        HessianProxyFactory factory = new HessianProxyFactory();\n");
            output.write("        //Doesn't Use Hessian protocol V2 because it's not completely stable with Spring AOP proxies)\n");
            output.write("        factory.setHessian2Reply(false);\n");
            output.write("        factory.setHessian2Request(false);\n");
            output.write("\n");
            output.write("        //Create service proxy\n");
            output.write("        " + wsType + " ws = (" + wsType + ") factory\n");
            output.write("                .create(" + wsType + ".class, address);\n");
            output.write("        return ws;\n");
            output.write("    }\n");
            output.write("\n");
            output.write("");
        }
        output.write("} //" + name + "\n");
        output.write("");
    }
}

