/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugengo.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugengo.EugengoUtils;
import org.nuiton.eugengo.generator.WikengoCommonGenerator;

public class ExceptionGenerator
extends WikengoCommonGenerator {
    public String getFilenameForClass(ObjectModelClass clazz) {
        String fqn = clazz.getQualifiedName();
        return fqn.replace('.', File.separatorChar) + ".java";
    }

    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!EugengoUtils.isException((ObjectModelClassifier)clazz)) {
            return;
        }
        this.generateCopyright(output);
        String packageName = clazz.getPackageName();
        String name = clazz.getName();
        output.write("package " + packageName + ";\n");
        output.write("\n");
        output.write("");
        ObjectModelClass superClass = this.findSuperClass(clazz);
        this.clearImports();
        this.lookForAttributeImports(clazz);
        this.addImport(superClass);
        if (EugengoUtils.isBusinessException((ObjectModelClassifier)clazz) && superClass == null) {
            this.addImport("org.sharengo.exceptions.BusinessException");
        }
        this.generateImports(output, packageName);
        this.generateClazzDocumentation(output, (ObjectModelClassifier)clazz, new String[0]);
        String extendsString = "Exception";
        if (EugengoUtils.isBusinessException((ObjectModelClassifier)clazz)) {
            extendsString = this.getType("org.sharengo.exceptions.BusinessException");
        }
        if (superClass != null) {
            extendsString = this.getType(superClass.getQualifiedName());
        }
        output.write("public class " + name + " extends " + extendsString + " {\n");
        output.write("\n");
        output.write("");
        String svUID = GeneratorUtil.computeSerialVersionUID((ObjectModelClass)clazz);
        output.write("    private static final long serialVersionUID = " + svUID + ";\n");
        output.write("\n");
        output.write("");
        this.generateStaticAttributes(output, clazz);
        this.generateExceptionConstructors(output, clazz);
        this.generateAttributesDeclaration(output, clazz);
        this.generateAttributesAccessors(output, clazz);
        output.write("} //" + name + "\n");
        output.write("");
    }
}

