/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugengo.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugengo.EugengoUtils;
import org.nuiton.eugengo.generator.WikengoCommonGenerator;

public class EntityHibernateXmlGenerator
extends WikengoCommonGenerator {
    public String getFilenameForClass(ObjectModelClass clazz) {
        String fqn = clazz.getQualifiedName();
        return fqn.replace('.', File.separatorChar) + ".hbm.xml";
    }

    public void generateFromClass(Writer output, ObjectModelClass entityClazz) throws IOException {
        if (!EugengoUtils.isEntity((ObjectModelClassifier)entityClazz) || this.findSuperClass(entityClazz) != null) {
            return;
        }
        this.generateCopyright(output);
        String packageName = entityClazz.getPackageName();
        String name = entityClazz.getName();
        String tableName = EugengoUtils.normalizeCapitalName(name);
        output.write("<?xml version=\"1.0\"?>\n");
        output.write("<!DOCTYPE hibernate-mapping\n");
        output.write("    PUBLIC \"-//Hibernate/Hibernate Mapping DTD//EN\"\n");
        output.write("    \"http://hibernate.sourceforge.net/hibernate-mapping-3.0.dtd\">\n");
        output.write("\n");
        output.write("<hibernate-mapping>\n");
        output.write("\n");
        output.write("    <class name=\"" + packageName + "." + name + "\" \n");
        output.write("        table=\"" + tableName + "\"  \n");
        output.write("        dynamic-update=\"true\">\n");
        output.write("\n");
        output.write("        <!-- Technical ID -->\n");
        output.write("        <id name=\"id\" type=\"string\" unsaved-value=\"null\" column=\"ID\">\n");
        output.write("            <generator class=\"uuid\"/>\n");
        output.write("        </id>\n");
        output.write("\n");
        output.write("");
        this.generateProperties(output, entityClazz, "");
        this.generateAssocitations(output, entityClazz, "");
        this.generateInheritance(output, entityClazz, "");
        output.write("    </class>\n");
        output.write("\n");
        output.write("</hibernate-mapping>\n");
        output.write("");
    }

    public void generateProperties(Writer output, ObjectModelClass entityClazz, String prefix) throws IOException {
        output.write("" + prefix + "        <!-- Properties -->\n");
        output.write("");
        for (ObjectModelAttribute attr : entityClazz.getAttributes()) {
            if (attr.getStereotypes() != null && !attr.getStereotypes().isEmpty() || attr.getClassifier() != null && EugengoUtils.isEntity(attr.getClassifier())) continue;
            String attrName = attr.getName();
            String attrColumn = EugengoUtils.normalizeCapitalName(attrName);
            String length = this.generateFromTagValue(attr, "length", "length");
            output.write("" + prefix + "        <property name=\"" + attrName + "\" column=\"" + attrColumn + "\" " + length + "/>\n");
            output.write("");
        }
        output.write("\n");
        output.write("");
    }

    public void generateAssocitations(Writer output, ObjectModelClass entityClazz, String prefix) throws IOException {
        output.write("" + prefix + "        <!-- Associations -->\n");
        output.write("");
        for (ObjectModelAttribute attr : entityClazz.getAttributes()) {
            if (attr.getStereotypes() != null && !attr.getStereotypes().isEmpty() || !attr.isNavigable() || attr.getClassifier() == null || !EugengoUtils.isEntity(attr.getClassifier())) continue;
            this.generateXmlAssocDocumentationBloc(output, entityClazz, attr, prefix);
            if (attr.getMaxMultiplicity() != -1) {
                if (attr.getReverseMaxMultiplicity() == -1) {
                    this.generateManyToOne(output, attr, false, prefix);
                    continue;
                }
                this.generateManyToOne(output, attr, true, prefix);
                continue;
            }
            if (attr.getReverseMaxMultiplicity() == -1) {
                this.generateManyToMany(output, entityClazz, attr, prefix);
                continue;
            }
            this.generateOneToMany(output, entityClazz, attr, prefix);
        }
        output.write("\n");
        output.write("");
    }

    public void generateInheritance(Writer output, ObjectModelClass entityClazz, String prefix) throws IOException {
        output.write("" + prefix + "        <!-- Inheritance -->\n");
        output.write("");
        Collection<ObjectModelClass> subClasses = this.findSubClasses(entityClazz);
        if (subClasses != null) {
            for (ObjectModelClass subClazz : subClasses) {
                String packageName = subClazz.getPackageName();
                String name = subClazz.getName();
                String tableName = EugengoUtils.normalizeCapitalName(name);
                String parentName = EugengoUtils.normalizeCapitalName(entityClazz.getName());
                output.write("" + prefix + "        <joined-subclass name=\"" + packageName + "." + name + "\"\n");
                output.write("" + prefix + "            table=\"" + tableName + "\"\n");
                output.write("" + prefix + "            dynamic-update=\"true\">\n");
                output.write("\n");
                output.write("" + prefix + "            <key column=\"FK_INHERITS_" + parentName + "_ID\"/>\n");
                output.write("\n");
                output.write("");
                String subPrefix = prefix + this.getString(' ', 4);
                this.generateProperties(output, subClazz, subPrefix);
                this.generateAssocitations(output, subClazz, subPrefix);
                this.generateInheritance(output, subClazz, subPrefix);
                output.write("" + prefix + "        </joined-subclass>\n");
                output.write("");
            }
        }
        output.write("\n");
        output.write("");
    }

    private String generateFromTagValue(ObjectModelAttribute attr, String tagName, String attributeName, String defaultValue) {
        String result = "";
        if (attr.hasTagValue(tagName) || defaultValue != null) {
            result = result + attributeName + "=\"";
            result = attr.hasTagValue(tagName) ? result + attr.getTagValue(tagName) : result + defaultValue;
            result = result + "\" ";
        }
        return result;
    }

    private String generateFromTagValue(ObjectModelAttribute attr, String tagName, String attributeName) {
        return this.generateFromTagValue(attr, tagName, attributeName, null);
    }

    public String getString(char ch, int nbOccur) {
        String result = "";
        for (int i = 0; i < nbOccur; ++i) {
            result = result + ch;
        }
        return result;
    }

    protected String getForeignKey(ObjectModelAttribute attr) {
        String result = "";
        result = result + EugengoUtils.normalizeCapitalName(attr.getClassifier().getName());
        result = result + "_";
        result = result + EugengoUtils.normalizeCapitalName(attr.getName());
        return result;
    }

    public void generateManyToOne(Writer output, ObjectModelAttribute attr, boolean isUnique, String prefix) throws IOException {
        String attrName = attr.getName();
        String attrType = attr.getType();
        String attrColumn = "FK_" + EugengoUtils.normalizeCapitalName(attr.getClassifier().getName()) + "_" + EugengoUtils.normalizeCapitalName(attr.getName()) + "_ID";
        String cascadeString = "";
        String additionalString = "";
        if (isUnique) {
            if (attr.getReverseAttribute() != null && attr.getReverseAttribute().isNavigable()) {
                cascadeString = "all";
            } else {
                cascadeString = "persist,merge,save-update";
                if (attr.isComposite()) {
                    cascadeString = cascadeString + ",delete";
                }
            }
        } else if (attr.getReverseAttribute() != null && attr.getReverseAttribute().isNavigable()) {
            if (attr.isComposite()) {
                cascadeString = "all";
            }
            if (attr.isOrdered()) {
                additionalString = "not-null=\"true\" insert=\"false\" update=\"false\"";
            }
        }
        output.write("" + prefix + "        <many-to-one name=\"" + attrName + "\"\n");
        output.write("" + prefix + "            class=\"" + attrType + "\"\n");
        output.write("" + prefix + "            column=\"" + attrColumn + "\"");
        if (!"".equals(cascadeString)) {
            output.write("\n");
            output.write("" + prefix + "            cascade=\"" + cascadeString + "\"");
        }
        if (!"".equals(additionalString)) {
            output.write("\n");
            output.write("" + prefix + "            " + additionalString + "");
        }
        if (isUnique) {
            output.write("\n");
            output.write("" + prefix + "            unique=\"true\"");
        }
        output.write("/>\n");
        output.write("");
    }

    public void generateOneToMany(Writer output, ObjectModelClass clazz, ObjectModelAttribute attr, String prefix) throws IOException {
        String attrName = attr.getName();
        String attrType = attr.getType();
        String cascadeType = "all";
        String keyColumn = "FK_" + EugengoUtils.normalizeCapitalName(clazz.getName()) + "_" + EugengoUtils.normalizeCapitalName(attr.getName()) + "_ID";
        String collType = attr.isOrdered() ? "list" : "set";
        String lazy = EugengoUtils.getTagValue(attr, "lazy", "true");
        String listIndex = "IDX";
        String keyNotNull = "";
        if (attr.getReverseAttribute() != null && attr.getReverseAttribute().isNavigable()) {
            cascadeType = "all-delete-orphan";
            keyColumn = "FK_" + EugengoUtils.normalizeCapitalName(clazz.getName()) + "_" + EugengoUtils.normalizeCapitalName(attr.getReverseAttributeName()) + "_ID";
            listIndex = EugengoUtils.normalizeCapitalName(attr.getName()) + "_IDX";
            keyNotNull = " not-null=\"true\"";
        }
        output.write("" + prefix + "        <" + collType + " name=\"" + attrName + "\"\n");
        output.write("" + prefix + "            lazy=\"" + lazy + "\"");
        if (attr.isAggregate() || attr.isComposite()) {
            output.write("\n");
            output.write("" + prefix + "            cascade=\"" + cascadeType + "\"");
        }
        output.write(">\n");
        output.write("" + prefix + "            <key column=\"" + keyColumn + "\"" + keyNotNull + "/>\n");
        output.write("");
        if (attr.isOrdered()) {
            output.write("" + prefix + "            <list-index column=\"" + listIndex + "\"/>\n");
            output.write("");
        }
        output.write("" + prefix + "            <one-to-many class=\"" + attrType + "\"/>\n");
        output.write("" + prefix + "        </" + collType + ">                \n");
        output.write("\n");
        output.write("");
    }

    public void generateManyToMany(Writer output, ObjectModelClass clazz, ObjectModelAttribute attr, String prefix) throws IOException {
        String collType;
        String attrName = attr.getName();
        String attrType = attr.getType();
        String tableName = "";
        String keyColumn = "FK_" + EugengoUtils.normalizeCapitalName(attr.getName()) + "_ID";
        if (attr.getReverseAttribute() == null || !attr.getReverseAttribute().isNavigable()) {
            keyColumn = EugengoUtils.normalizeCapitalName(clazz.getName()) + "_ID";
        }
        String attrColumn = EugengoUtils.normalizeCapitalName(attr.getClassifier().getName()) + "_ID";
        String string = collType = attr.isOrdered() ? "list" : "set";
        if (this.isMainEndPoint(clazz, attr)) {
            tableName = attr.getReverseAttribute() == null || !attr.getReverseAttribute().isNavigable() ? EugengoUtils.normalizeCapitalName(clazz.getName()) + "_" + EugengoUtils.normalizeCapitalName(attr.getName()) : EugengoUtils.normalizeCapitalName(attr.getName()) + "_" + EugengoUtils.normalizeCapitalName(attr.getReverseAttributeName());
        }
        output.write("" + prefix + "        <" + collType + " name=\"" + attrName + "\"");
        if (!"".equals(tableName)) {
            output.write("\n");
            output.write("" + prefix + "            table=\"" + tableName + "\"");
        } else {
            output.write("\n");
            output.write("" + prefix + "            inverse=\"true\"");
        }
        output.write(">\n");
        output.write("" + prefix + "            <key column=\"" + keyColumn + "\"/>\n");
        output.write("");
        if (attr.isOrdered()) {
            output.write("" + prefix + "            <list-index column=\"IDX\"/>\n");
            output.write("");
        }
        output.write("" + prefix + "            <many-to-many\n");
        output.write("" + prefix + "                class=\"" + attrType + "\"\n");
        output.write("" + prefix + "                column=\"" + attrColumn + "\"/>\n");
        output.write("" + prefix + "        </" + collType + ">                \n");
        output.write("\n");
        output.write("");
    }

    private boolean isMainEndPoint(ObjectModelClass clazz, ObjectModelAttribute attr) {
        if (attr.getReverseAttribute() == null || !attr.getReverseAttribute().isNavigable()) {
            return true;
        }
        if (attr.isComposite()) {
            return true;
        }
        if (attr.getReverseAttribute().isComposite()) {
            return false;
        }
        String type = attr.getType().substring(attr.getType().lastIndexOf(46) + 1);
        return clazz.getName().compareToIgnoreCase(type) > 0;
    }

    public void generateXmlAssocDocumentationBloc(Writer output, ObjectModelClass clazz, ObjectModelAttribute attr, String prefix) throws IOException {
        if (!attr.isNavigable()) {
            return;
        }
        String leftElement = EugengoUtils.normalizeCapitalName(clazz.getName());
        String rightElement = EugengoUtils.normalizeCapitalName(attr.getClassifier().getName());
        output.write("" + prefix + "        <!--  ");
        output.write("" + this.getString('_', leftElement.length() + 2) + "");
        output.write("" + this.getString(' ', 12) + "");
        output.write("" + this.getString('_', rightElement.length() + 2) + "\n");
        output.write("");
        output.write("" + prefix + "             ");
        output.write("| " + leftElement + " |");
        if (attr.getReverseAttribute() == null || attr.getReverseAttribute().isNavigable()) {
            output.write("<=");
        } else {
            output.write("==");
        }
        String mult = "*";
        if (attr.getReverseMaxMultiplicity() != -1) {
            mult = "" + attr.getReverseMaxMultiplicity();
        }
        output.write("" + mult + "");
        output.write("" + this.getString('=', 4) + "");
        mult = "*";
        if (attr.getMaxMultiplicity() != -1) {
            mult = "" + Math.max(attr.getMinMultiplicity(), attr.getMaxMultiplicity());
        }
        output.write("" + mult + "");
        if (attr.isNavigable()) {
            output.write("=>");
        } else {
            output.write("==");
        }
        output.write("| " + rightElement + " |\n");
        output.write("");
        output.write("" + prefix + "             ");
        output.write("|" + this.getString('_', leftElement.length() + 2) + "|");
        output.write("" + this.getString(' ', 10) + "");
        output.write("|" + this.getString('_', rightElement.length() + 2) + "|\n");
        output.write("");
        output.write("" + prefix + "        -->\n");
        output.write("");
    }
}

