/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugengo.generator;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugengo.EugengoUtils;
import org.nuiton.eugengo.generator.WikengoCommonGenerator;

public class EntityGenerator
extends WikengoCommonGenerator {
    public String getFilenameForClass(ObjectModelClass clazz) {
        String fqn = clazz.getQualifiedName();
        return fqn.replace('.', File.separatorChar) + ".java";
    }

    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!EugengoUtils.isEntity((ObjectModelClassifier)clazz)) {
            return;
        }
        this.generateCopyright(output);
        String packageName = clazz.getPackageName();
        String name = clazz.getName();
        output.write("package " + packageName + ";\n");
        output.write("\n");
        output.write("");
        ObjectModelClass superClass = this.findSuperClass(clazz);
        this.clearImports();
        this.addImport(Serializable.class);
        this.addImport(superClass);
        this.lookForAttributeImports(clazz);
        this.generateImports(output, packageName);
        this.generateClazzDocumentation(output, (ObjectModelClassifier)clazz, new String[0]);
        String extendsString = "";
        if (superClass != null) {
            extendsString = " extends " + this.getType(superClass.getQualifiedName());
        }
        String abstractString = "";
        if (clazz.isAbstract()) {
            abstractString = abstractString + "abstract ";
        }
        output.write("public " + abstractString + "class " + name + "" + extendsString + " implements Serializable {\n");
        output.write("\n");
        output.write("");
        String svUID = GeneratorUtil.computeSerialVersionUID((ObjectModelClass)clazz);
        output.write("    private static final long serialVersionUID = " + svUID + ";\n");
        output.write("\n");
        output.write("");
        this.generateStaticAttributes(output, clazz);
        this.generatePropertyConstant(output, "id");
        this.generatePropertiesConstant(output, clazz);
        output.write("    /**\n");
        output.write("     * Automatic primary key.\n");
        output.write("     */\n");
        output.write("    protected String id;\n");
        output.write("\n");
        output.write("");
        this.generateAttributesDeclaration(output, clazz);
        output.write("    // Accessors for primary key\n");
        output.write("    public void setId(String id) {\n");
        output.write("        this.id = id;\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    public String getId() {\n");
        output.write("        return this.id;\n");
        output.write("    }\n");
        output.write("\n");
        output.write("");
        this.generateAttributesAccessors(output, clazz);
        this.generateHashCode(output, clazz);
        output.write("    public boolean equals(Object other) {\n");
        output.write("        if (other == null) {\n");
        output.write("            return false;\n");
        output.write("        }\n");
        output.write("        if (!(other instanceof " + name + ")) {\n");
        output.write("            return false;\n");
        output.write("        }\n");
        output.write("        if (id == null) {\n");
        output.write("            return ((" + name + ")other).getId() == null;\n");
        output.write("        }\n");
        output.write("        return id.equals(((" + name + ")other).getId());\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    public String toString() {\n");
        output.write("        return this.getClass().getName() + \"[id=\" + id + \"]\";\n");
        output.write("    }\n");
        output.write("\n");
        output.write("} //" + name + "\n");
        output.write("");
    }

    protected void generatePropertiesConstant(Writer output, ObjectModelClass clazz) throws IOException {
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable() || attr.isStatic() || attr.getStereotypes() != null && !attr.getStereotypes().isEmpty()) continue;
            this.generatePropertyConstant(output, attr.getName());
        }
    }

    protected void generatePropertyConstant(Writer output, String propertyName) throws IOException {
        String constantName = propertyName.toUpperCase();
        output.write("    /**\n");
        output.write("     * Constant representing the name of the field \"" + propertyName + "\".\n");
        output.write("     */\n");
        output.write("    public static final String PROP_" + constantName + " = \"" + propertyName + "\";\n");
        output.write("\n");
        output.write("");
    }
}

