/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugengo.generator;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugengo.EugengoUtils;
import org.nuiton.eugengo.generator.WikengoCommonGenerator;

public class DtoGenerator
extends WikengoCommonGenerator {
    public String getFilenameForClass(ObjectModelClass clazz) {
        String fqn = clazz.getQualifiedName();
        return fqn.replace('.', File.separatorChar) + ".java";
    }

    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!EugengoUtils.isDto((ObjectModelClassifier)clazz)) {
            return;
        }
        this.generateCopyright(output);
        String packageName = clazz.getPackageName();
        String name = clazz.getName();
        output.write("package " + packageName + ";\n");
        output.write("\n");
        output.write("");
        ObjectModelClass superClass = this.findSuperClass(clazz);
        this.clearImports();
        this.addImport(Serializable.class);
        this.addImport(superClass);
        this.lookForAttributeImports(clazz);
        this.generateImports(output, packageName);
        this.generateClazzDocumentation(output, (ObjectModelClassifier)clazz, new String[0]);
        String extendsString = "";
        if (superClass != null) {
            extendsString = " extends " + this.getType(superClass.getQualifiedName());
        }
        String abstractString = "";
        if (clazz.isAbstract()) {
            abstractString = abstractString + "abstract ";
        }
        output.write("public " + abstractString + "class " + name + "" + extendsString + " implements Serializable {\n");
        output.write("\n");
        output.write("");
        String svUID = GeneratorUtil.computeSerialVersionUID((ObjectModelClass)clazz);
        output.write("    private static final long serialVersionUID = " + svUID + ";\n");
        output.write("\n");
        output.write("");
        this.generateStaticAttributes(output, clazz);
        this.generateAttributesDeclaration(output, clazz);
        this.generateDefaultConstructor(output, name);
        this.generateFullConstructor(output, name, clazz.getAttributes());
        this.generateAttributesAccessors(output, clazz);
        this.generateHashCode(output, clazz);
        output.write("} //" + name + "\n");
        output.write("");
    }
}

