/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugengo.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugengo.generator.DaoCommonGenerator;

public class DaoGenerator
extends DaoCommonGenerator {
    public String getFilenameForClass(ObjectModelClass clazz) {
        String fqn = DaoGenerator.getQualifiedName(clazz);
        return fqn.replace('.', File.separatorChar) + ".java";
    }

    public static String getPackageName(ObjectModelClass clazz) {
        String result = clazz.getPackageName();
        result = result.replace(".entities", ".daos");
        return result;
    }

    public static String getQualifiedName(ObjectModelClass clazz) {
        return DaoGenerator.getPackageName(clazz) + "." + DaoGenerator.getClassName(clazz);
    }

    public static String getClassName(ObjectModelClass clazz) {
        return clazz.getName() + "Dao";
    }

    @Override
    protected void generateFromEntity(Writer output, ObjectModelClass entityClazz, ObjectModelClassifier daoClazz) throws IOException {
        this.generateCopyright(output);
        String packageName = DaoGenerator.getPackageName(entityClazz);
        String name = DaoGenerator.getClassName(entityClazz);
        String entityFqn = entityClazz.getQualifiedName();
        String entityName = entityClazz.getName();
        output.write("package " + packageName + ";\n");
        output.write("\n");
        output.write("");
        this.clearImports();
        this.addImport("org.sharengo.orm.DAO");
        this.addImport("org.sharengo.dtos.PagedResult");
        if (this.hasNavigableAndNonStaticAttributes(entityClazz)) {
            this.addImport(List.class);
        }
        this.lookForAttributeImports(entityClazz);
        if (daoClazz != null) {
            this.lookForOperationImports(daoClazz);
        }
        this.addImport(entityFqn);
        this.generateImports(output, packageName);
        output.write("/**\n");
        output.write(" * DAO interface to manage " + entityName + ".\n");
        output.write(" */\n");
        output.write("public interface " + name + " extends DAO<" + entityName + "> {\n");
        output.write("\n");
        output.write("    /*\n");
        output.write("     * Generated methods\n");
        output.write("     */\n");
        output.write("");
        String entityType = this.getType(entityFqn);
        for (ObjectModelAttribute attr : entityClazz.getAttributes()) {
            if (!attr.isNavigable() || attr.getStereotypes() != null && !attr.getStereotypes().isEmpty()) continue;
            String attrName = attr.getName();
            output.write("    // findBy \"" + attrName + "\" methods\n");
            output.write("");
            this.generateFindByPropertyHeader(output, entityType, attr, true);
            this.generateFindAllByPropertyHeader(output, entityType, attr, true, false);
            this.generateFindAllByPropertyHeader(output, entityType, attr, true, true);
        }
        if (daoClazz != null) {
            output.write("    /*\n");
            output.write("     * Dao defined methods\n");
            output.write("     */\n");
            output.write("");
            for (ObjectModelOperation op : daoClazz.getOperations()) {
                this.generateOperationHeader(output, op, true, new String[0]);
            }
        }
        output.write("} //" + name + "\n");
        output.write("");
    }
}

