/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugengo.generator;

import java.io.IOException;
import java.io.Writer;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelDependency;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugengo.EugengoUtils;
import org.nuiton.eugengo.generator.WikengoCommonGenerator;

public abstract class DaoCommonGenerator
extends WikengoCommonGenerator {
    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!EugengoUtils.isEntity((ObjectModelClassifier)clazz)) {
            return;
        }
        ObjectModelClassifier daoClass = this.findClassWithStereotypeAndDependency(this.model, clazz, "Dao");
        this.generateFromEntity(output, clazz, daoClass);
    }

    protected abstract void generateFromEntity(Writer var1, ObjectModelClass var2, ObjectModelClassifier var3) throws IOException;

    protected ObjectModelClassifier findClassWithStereotypeAndDependency(ObjectModel model, ObjectModelClass clazz, String stereotype) {
        for (ObjectModelClassifier classifier : model.getClassifiers()) {
            if (!EugengoUtils.hasStereotype((ObjectModelElement)classifier, (String)stereotype)) continue;
            for (ObjectModelDependency dependency : classifier.getDependencies()) {
                if (dependency.getSupplier() == null || !clazz.equals(dependency.getSupplier())) continue;
                return classifier;
            }
        }
        return null;
    }

    protected void generateFindByPropertyHeader(Writer output, String entityType, ObjectModelAttribute attr, boolean generateForInterface) throws IOException {
        String attrName = EugengoUtils.toUpperCaseFirstLetter((String)attr.getName());
        String attrVarName = EugengoUtils.toLowerCaseFirstLetter((String)attr.getName());
        String attrType = this.getType(attr.getType());
        String visibility = "";
        if (!generateForInterface) {
            visibility = "public ";
        }
        output.write("    " + visibility + "" + entityType + " findBy" + attrName + "(" + attrType + " " + attrVarName + ")");
        if (generateForInterface) {
            output.write(";\n");
            output.write("\n");
            output.write("");
        } else {
            output.write(" {\n");
            output.write("");
        }
    }

    protected void generateFindAllByPropertyHeader(Writer output, String entityType, ObjectModelAttribute attr, boolean generateForInterface, boolean withPagination) throws IOException {
        String attrName = EugengoUtils.toUpperCaseFirstLetter((String)attr.getName());
        String attrVarName = EugengoUtils.toLowerCaseFirstLetter((String)attr.getName());
        String attrType = this.getType(attr.getType());
        String visibility = "";
        String listType = "List";
        String paginationParameters = "";
        if (withPagination) {
            listType = "PagedResult";
            paginationParameters = ", int start, int end";
        }
        if (!generateForInterface) {
            visibility = "public ";
        }
        output.write("    " + visibility + "" + listType + "<" + entityType + "> findAllBy" + attrName + "(" + attrType + " " + attrVarName + "" + paginationParameters + ")");
        if (generateForInterface) {
            output.write(";\n");
            output.write("\n");
            output.write("");
        } else {
            output.write(" {\n");
            output.write("");
        }
    }
}

