/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugengo.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugengo.EugengoUtils;
import org.nuiton.eugengo.generator.DaoCommonGenerator;
import org.nuiton.eugengo.generator.DaoGenerator;

public class DaoAbstractGenerator
extends DaoCommonGenerator {
    public String getFilenameForClass(ObjectModelClass clazz) {
        String fqn = DaoAbstractGenerator.getQualifiedName(clazz);
        return fqn.replace('.', File.separatorChar) + ".java";
    }

    public static String getQualifiedName(ObjectModelClass clazz) {
        return DaoAbstractGenerator.getPackageName(clazz) + "." + DaoAbstractGenerator.getClassName(clazz);
    }

    private static String getClassName(ObjectModelClass clazz) {
        return "Abstract" + clazz.getName() + "Dao";
    }

    private static String getPackageName(ObjectModelClass clazz) {
        return DaoGenerator.getPackageName(clazz) + ".impl";
    }

    @Override
    protected void generateFromEntity(Writer output, ObjectModelClass entityClazz, ObjectModelClassifier daoClazz) throws IOException {
        this.generateCopyright(output);
        String packageName = DaoAbstractGenerator.getPackageName(entityClazz);
        String name = DaoAbstractGenerator.getClassName(entityClazz);
        String entityFqn = entityClazz.getQualifiedName();
        String entityName = entityClazz.getName();
        String parentInterface = DaoGenerator.getQualifiedName(entityClazz);
        output.write("package " + packageName + ";\n");
        output.write("\n");
        output.write("");
        this.clearImports();
        this.lookForAttributeImports(entityClazz);
        this.addImport("org.sharengo.orm.hibernate.AbstractHibernateDAO");
        this.addImport("org.sharengo.dtos.PagedResult");
        this.addImport(entityFqn);
        if (this.hasNavigableAndNonStaticAttributes(entityClazz)) {
            this.addImport(List.class);
        }
        this.addImport(parentInterface);
        this.generateImports(output, packageName);
        String entityType = this.getType(entityFqn);
        String extension = "extends AbstractHibernateDAO<" + entityType + "> implements " + this.getType(parentInterface);
        output.write("/*\n");
        output.write(" * DAO abstract implementation for " + entityName + "\n");
        output.write(" */\n");
        output.write("public abstract class " + name + " " + extension + " {\n");
        output.write("\n");
        output.write("    @Override\n");
        output.write("    protected Class<" + entityType + "> getEntity() {\n");
        output.write("        return " + entityType + ".class;\n");
        output.write("    }\n");
        output.write("\n");
        output.write("");
        for (ObjectModelAttribute attr : entityClazz.getAttributes()) {
            if (!attr.isNavigable() || attr.getStereotypes() != null && !attr.getStereotypes().isEmpty()) continue;
            String attrName = attr.getName();
            output.write("    // findBy \"" + attrName + "\" methods\n");
            output.write("");
            String attrConstantName = attrName.toUpperCase();
            String attrVarName = EugengoUtils.toLowerCaseFirstLetter((String)attrName);
            this.generateFindByPropertyHeader(output, entityType, attr, false);
            output.write("        return super.findByProperty(" + entityType + ".PROP_" + attrConstantName + ", " + attrVarName + ");\n");
            output.write("    }\n");
            output.write("\n");
            output.write("");
            this.generateFindAllByPropertyHeader(output, entityType, attr, false, false);
            output.write("        return super.findAllByProperty(" + entityType + ".PROP_" + attrConstantName + ", " + attrVarName + ", 0, -1).getList();\n");
            output.write("    }\n");
            output.write("\n");
            output.write("");
            this.generateFindAllByPropertyHeader(output, entityType, attr, false, true);
            output.write("        return super.findAllByProperty(" + entityType + ".PROP_" + attrConstantName + ", " + attrVarName + ", start, end);\n");
            output.write("    }\n");
            output.write("\n");
            output.write("");
        }
        output.write("} //" + name + "\n");
        output.write("");
    }
}

