/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugengo.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.eugengo.EugengoUtils;
import org.nuiton.eugengo.generator.WikengoCommonGenerator;

public class BusinessEntityInterfaceGenerator
extends WikengoCommonGenerator {
    private static final Log log = LogFactory.getLog(BusinessEntityInterfaceGenerator.class);
    protected String EXT_NAME;

    public String getFilenameForClass(ObjectModelClass clazz) {
        String fqn = clazz.getQualifiedName();
        log.info((Object)("Filename for " + clazz.getName() + " is " + fqn.replace('.', File.separatorChar) + ".java"));
        return fqn.replace('.', File.separatorChar) + ".java";
    }

    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!EugengoUtils.isBusinessEntity((ObjectModelClassifier)clazz)) {
            log.info((Object)(clazz.getName() + " is not a business entity"));
            return;
        }
        log.info((Object)("Generate Business entity " + clazz.getName() + "... "));
        this.generateCopyright(output);
        this.EXT_NAME = "EXT_" + clazz.getName().toUpperCase();
        String packageName = clazz.getPackageName();
        String name = clazz.getName();
        output.write("package " + packageName + ";\n");
        output.write("\n");
        output.write("");
        ObjectModelClass superClass = this.findSuperClass(clazz);
        this.clearImports();
        this.addImport(superClass);
        this.addImport("org.sharengo.wikitty.BusinessEntity");
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (!EugengoUtils.isBusinessEntity((ObjectModelClassifier)parent)) continue;
            this.addImport(parent);
        }
        this.lookForAttributeImports(clazz);
        this.generateImports(output, packageName);
        String extendsString = "extends " + this.getType("org.sharengo.wikitty.BusinessEntity");
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (!EugengoUtils.isBusinessEntity((ObjectModelClassifier)parent)) continue;
            extendsString = extendsString + ", " + this.getType(parent.getName());
        }
        output.write("public interface " + name + " " + extendsString + " {\n");
        output.write("\n");
        output.write("\tstatic final public String " + this.EXT_NAME + " = \"" + clazz.getName() + "\";\n");
        output.write("\n");
        output.write("");
        this.generateFieldNameConstant(output, clazz);
        this.generateStaticAttributes(output, clazz);
        this.generateAttributeAccessMethod(output, clazz);
        output.write("\n");
        output.write("} //" + name + "\n");
        output.write("");
    }

    private void generateFieldNameConstant(Writer output, ObjectModelClass clazz) throws IOException {
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable() || attr.isStatic() || attr.getStereotypes() != null && !attr.getStereotypes().isEmpty()) continue;
            output.write("    static final public String FIELD_" + attr.getName().toUpperCase() + " = \"" + attr.getName() + "\";\n");
            output.write("    static final public String FQ_FIELD_" + attr.getName().toUpperCase() + " = " + this.EXT_NAME + " + \"." + attr.getName() + "\";\n");
            output.write("");
        }
    }

    public void generateAttributeAccessMethod(Writer output, ObjectModelClass clazz) throws IOException {
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable() || attr.isStatic() || attr.getStereotypes() != null && !attr.getStereotypes().isEmpty()) continue;
            if (attr.getMaxMultiplicity() != 0 && attr.getMaxMultiplicity() != 1) {
                this.generateCollectionAttributeAccessors(output, attr);
                continue;
            }
            this.generateWikittyAttributeAccessors(output, attr);
        }
    }

    protected void generateWikittyAttributeAccessors(Writer output, ObjectModelAttribute attr) throws IOException {
        String attrType = this.computeType((ObjectModelParameter)attr);
        if (!EugengoUtils.notEmpty((String)attrType)) {
            return;
        }
        attrType = this.getType(attrType, true);
        String attrName = attr.getName();
        String attrNameCapitalized = EugengoUtils.toUpperCaseFirstLetter((String)attrName);
        output.write("\n");
        output.write("    public void set" + attrNameCapitalized + "(" + attrType + " " + attrName + ");\n");
        output.write("    public " + attrType + " get" + attrNameCapitalized + "();\n");
        output.write("\n");
        output.write("");
    }

    protected void generateCollectionAttributeAccessors(Writer output, ObjectModelAttribute attr) throws IOException {
        String attrType = this.computeType((ObjectModelParameter)attr);
        if (!EugengoUtils.notEmpty((String)attrType)) {
            return;
        }
        attrType = this.getType(attrType, true);
        String elementType = this.getType(attr.getType(), true);
        String attrName = attr.getName();
        String attrNameCapitalized = EugengoUtils.toUpperCaseFirstLetter((String)attrName);
        output.write("    public " + attrType + " get" + attrNameCapitalized + "();\n");
        output.write("    public void add" + attrNameCapitalized + "(" + elementType + " element);\n");
        output.write("    public void remove" + attrNameCapitalized + "(" + elementType + " element);\n");
        output.write("    public void clear" + attrNameCapitalized + "();\n");
        output.write("\n");
        output.write("");
    }
}

