/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugengo.generator;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.eugengo.EugengoUtils;
import org.nuiton.eugengo.generator.WikengoCommonGenerator;

public class BusinessEntityBeanGenerator
extends WikengoCommonGenerator {
    private static final Log log = LogFactory.getLog(BusinessEntityBeanGenerator.class);
    protected String EXT_NAME;
    protected Boolean generatePropertyChangeListener;
    private static Set<String> commonTypes = new HashSet<String>();

    public String getFilenameForClass(ObjectModelClass clazz) {
        String fqn = clazz.getQualifiedName();
        log.info((Object)("Filename for " + clazz.getName() + " is " + fqn.replace('.', File.separatorChar) + ".java"));
        return fqn.replace('.', File.separatorChar) + "Bean.java";
    }

    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!EugengoUtils.isBusinessEntity((ObjectModelClassifier)clazz)) {
            log.info((Object)(clazz.getName() + " is not a business entity"));
            return;
        }
        log.info((Object)("Generate Bean Business entity " + clazz.getName() + "... "));
        String genPCS = EugengoUtils.findTagValue((String)"generatePropertyChangeListener", (ObjectModelElement)clazz, (Model)this.model);
        this.generatePropertyChangeListener = genPCS != null && "true".equals(genPCS.trim());
        this.generateCopyright(output);
        String packageName = clazz.getPackageName();
        String name = clazz.getName() + "Bean";
        output.write("package " + packageName + ";\n");
        output.write("\n");
        output.write("");
        ObjectModelClass superClass = this.findSuperClass(clazz);
        this.clearImports();
        this.addImport(clazz);
        this.addImport(superClass);
        this.addImport("org.sharengo.wikitty.BusinessEntityBean");
        String parentBean = null;
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (!EugengoUtils.isBusinessEntity((ObjectModelClassifier)parent)) continue;
            this.addImport(parent);
            parentBean = parent.getQualifiedName() + "Bean";
            this.addImport(parentBean);
        }
        if (this.generatePropertyChangeListener.booleanValue()) {
            this.addImport(PropertyChangeSupport.class.getName());
            this.addImport(PropertyChangeListener.class.getName());
        }
        this.lookForAttributeImports(clazz);
        this.generateImports(output, packageName);
        this.generateClazzDocumentation(output, (ObjectModelClassifier)clazz, new String[0]);
        String extendsString = " extends " + (parentBean != null ? parentBean : this.getType("org.sharengo.wikitty.BusinessEntityBean"));
        String abstractString = "";
        if (clazz.isAbstract()) {
            abstractString = abstractString + "abstract ";
        }
        String implementsString = "implements " + this.getType(clazz.getQualifiedName());
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (!EugengoUtils.isBusinessEntity((ObjectModelClassifier)parent)) continue;
            implementsString = implementsString + ", " + this.getType(parent.getQualifiedName());
        }
        output.write("public " + abstractString + "class " + name + "" + extendsString + " " + implementsString + " {\n");
        output.write("\n");
        output.write("");
        String svUID = GeneratorUtil.computeSerialVersionUID((ObjectModelClass)clazz);
        output.write("    private static final long serialVersionUID = " + svUID + ";\n");
        output.write("\n");
        output.write("    public " + name + "() {\n");
        output.write("        super();\n");
        output.write("    }\n");
        output.write("\n");
        output.write(" ");
        if (this.generatePropertyChangeListener.booleanValue()) {
            output.write("    protected PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);\n");
            output.write("\n");
            output.write("    public void addPropertyChangeListener(PropertyChangeListener listener) {\n");
            output.write("\t\tpropertyChange.addPropertyChangeListener(listener);\n");
            output.write("\t}\n");
            output.write("\n");
            output.write("\tpublic void removePropertyChangeListener(PropertyChangeListener listener) {\n");
            output.write("\t\tpropertyChange.removePropertyChangeListener(listener);\n");
            output.write("\t}\n");
            output.write("\n");
            output.write("\tpublic void addPropertyChangeListener(String propertyName,PropertyChangeListener listener) {\n");
            output.write("\t\tpropertyChange.addPropertyChangeListener(propertyName, listener);\n");
            output.write("\t}\n");
            output.write("\n");
            output.write("\tpublic void removePropertyChangeListener(String propertyName,PropertyChangeListener listener) {\n");
            output.write("\t\tpropertyChange.removePropertyChangeListener(propertyName, listener);\n");
            output.write("\t}\n");
            output.write("\n");
            output.write("");
        }
        this.generateFieldAndMethod(output, clazz);
        output.write("\n");
        output.write("} //" + name + "\n");
        output.write("");
    }

    private void generateFieldAndMethod(Writer output, ObjectModelClass clazz) throws IOException {
        this.generateWikittyField(output, clazz);
        this.generateAttributeAccessMethod(output, clazz);
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (!EugengoUtils.isBusinessEntity((ObjectModelClassifier)parent)) continue;
            this.generateFieldAndMethod(output, parent);
        }
    }

    private void generateWikittyField(Writer output, ObjectModelClass clazz) throws IOException {
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable() || attr.isStatic() || attr.getStereotypes() != null && !attr.getStereotypes().isEmpty()) continue;
            this.generateAttribute(output, attr);
        }
    }

    private void generateAttributeAccessMethod(Writer output, ObjectModelClass clazz) throws IOException {
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable() || attr.isStatic() || attr.getStereotypes() != null && !attr.getStereotypes().isEmpty()) continue;
            if (attr.getMaxMultiplicity() != 0 && attr.getMaxMultiplicity() != 1) {
                this.generateCollectionAttributeAccessors(output, attr);
                continue;
            }
            this.generateWikittyAttributeAccessors(output, attr);
        }
    }

    private void generateAttribute(Writer output, ObjectModelAttribute attr) throws IOException {
        this.EXT_NAME = attr.getDeclaringElement().getName();
        String attrType = this.computeType((ObjectModelParameter)attr);
        if (!EugengoUtils.notEmpty((String)attrType)) {
            return;
        }
        attrType = this.getType(attrType, true);
        String attrName = this.EXT_NAME + "$" + attr.getName();
        output.write("    public " + attrType + " " + attrName + ";\n");
        output.write("\n");
        output.write(" ");
    }

    private void generateWikittyAttributeAccessors(Writer output, ObjectModelAttribute attr) throws IOException {
        this.EXT_NAME = attr.getDeclaringElement().getName();
        String attrType = this.computeType((ObjectModelParameter)attr);
        if (!EugengoUtils.notEmpty((String)attrType)) {
            return;
        }
        attrType = this.getType(attrType, true);
        String simpleAttrName = attr.getName();
        String attrNameCapitalized = EugengoUtils.toUpperCaseFirstLetter((String)simpleAttrName);
        String attrName = this.EXT_NAME + "$" + simpleAttrName;
        String genPCS = "";
        if (!this.generatePropertyChangeListener.booleanValue()) {
            genPCS = "//";
        }
        output.write("\n");
        output.write("    public void set" + attrNameCapitalized + "(" + attrType + " value) {\n");
        output.write("        " + genPCS + "Object oldValue = " + attrName + "; \n");
        output.write("        this." + attrName + " = value;\n");
        output.write("        " + genPCS + "propertyChange.firePropertyChange(\"" + simpleAttrName + "\", oldValue, value);\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    public " + attrType + " get" + attrNameCapitalized + "() {\n");
        output.write("        return " + attrName + ";\n");
        output.write("    }\n");
        output.write("\n");
        output.write("");
    }

    private void generateCollectionAttributeAccessors(Writer output, ObjectModelAttribute attr) throws IOException {
        this.EXT_NAME = attr.getDeclaringElement().getName();
        String attrType = this.computeType((ObjectModelParameter)attr);
        if (!EugengoUtils.notEmpty((String)attrType)) {
            return;
        }
        attrType = this.getType(attrType, true);
        String elementType = this.getType(attr.getType(), true);
        String simpleAttrName = attr.getName();
        String attrNameCapitalized = EugengoUtils.toUpperCaseFirstLetter((String)simpleAttrName);
        String attrName = this.EXT_NAME + "$" + simpleAttrName;
        String genPCS = "";
        if (!this.generatePropertyChangeListener.booleanValue()) {
            genPCS = "//";
        }
        output.write("    public " + attrType + " get" + attrNameCapitalized + "() {\n");
        output.write("        return " + attrName + ";\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    public void add" + attrNameCapitalized + "(" + elementType + " element) {\n");
        output.write("        " + attrName + ".add(element);\n");
        output.write("        " + genPCS + "propertyChange.firePropertyChange(\"" + simpleAttrName + "\", null, " + attrName + ");\n");
        output.write("    }\n");
        output.write("    \n");
        output.write("    public void remove" + attrNameCapitalized + "(" + elementType + " element) {\n");
        output.write("        " + attrName + ".remove(element);\n");
        output.write("        " + genPCS + "propertyChange.firePropertyChange(\"" + simpleAttrName + "\", null, " + attrName + ");\n");
        output.write("    }\n");
        output.write("    \n");
        output.write("    public void clear" + attrNameCapitalized + "() {\n");
        output.write("        " + attrName + ".clear();\n");
        output.write("        " + genPCS + "propertyChange.firePropertyChange(\"" + simpleAttrName + "\", null, " + attrName + ");\n");
        output.write("    }\n");
        output.write("\n");
        output.write("");
    }

    static {
        commonTypes.add("byte");
        commonTypes.add("Byte");
        commonTypes.add("short");
        commonTypes.add("Short");
        commonTypes.add("int");
        commonTypes.add("Integer");
        commonTypes.add("long");
        commonTypes.add("Long");
        commonTypes.add("float");
        commonTypes.add("Float");
        commonTypes.add("double");
        commonTypes.add("Double");
        commonTypes.add("char");
        commonTypes.add("Char");
        commonTypes.add("boolean");
        commonTypes.add("Boolean");
        commonTypes.add("Date");
        commonTypes.add("String");
    }
}

