package org.nuiton.eugengo.generator.test;

import java.io.File;
import java.io.IOException;
import java.io.Writer;

import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugengo.EugengoUtils;
import org.nuiton.eugengo.generator.WikengoCommonGenerator;

public class ServiceTestGenerator extends WikengoCommonGenerator {

    @Override
    public String getFilenameForClassifier(ObjectModelClassifier clazz) {
        String fqn = clazz.getQualifiedName();
        return fqn.replace('.', File.separatorChar) + "Test.java";
    }

    @Override
    public void generateFromClassifier(Writer output,
            ObjectModelClassifier clazz) throws IOException {
        if (!EugengoUtils.isService(clazz)) {
            return;
        }

        generateCopyright(output);

        String packageName = clazz.getPackageName();
        String name = clazz.getName() + "Test";
        String testedClassName = clazz.getQualifiedName();
output.write("package "+packageName+";\n");
output.write("\n");
output.write("");

        clearImports();
        generateImports(output, packageName);

output.write("/**\n");
output.write(" * @see "+testedClassName+"\n");
output.write(" */\n");
output.write("public interface "+name+" {\n");
output.write("\n");
output.write("");

        if (EugengoUtils.isCrudService(clazz)) {
output.write("    //crud test methods\n");
output.write("    /**\n");
output.write("     * @see "+testedClassName+"#create\n");
output.write("     */\n");
output.write("    public void testCreate() throws Exception;\n");
output.write("\n");
output.write("    /**\n");
output.write("     * @see "+testedClassName+"#find\n");
output.write("     */\n");
output.write("    public void testFind() throws Exception;\n");
output.write("\n");
output.write("    /**\n");
output.write("     * @see "+testedClassName+"#update\n");
output.write("     */\n");
output.write("    public void testUpdate() throws Exception;\n");
output.write("\n");
output.write("    /**\n");
output.write("     * @see "+testedClassName+"#delete\n");
output.write("     */\n");
output.write("    public void testDelete() throws Exception;\n");
output.write("\n");
output.write("    /**\n");
output.write("     * @see "+testedClassName+"#findAll\n");
output.write("     */\n");
output.write("    public void testFindAll() throws Exception;\n");
output.write("\n");
output.write("");
        }

output.write("    //specific test methods\n");
output.write("");

        for (ObjectModelOperation op : clazz.getOperations()) {
            //FIXME Manage the case when two operations have the same name
            String opName = op.getName();
            String opMethodName = EugengoUtils.toUpperCaseFirstLetter(opName);
            //TODO distinguish method parameters in javadoc @see
output.write("    /**\n");
output.write("     * @see "+testedClassName+"#"+opName+"\n");
output.write("     */\n");
output.write("    public void test"+opMethodName+"() throws Exception;\n");
output.write("\n");
output.write("");
        }

output.write("} //"+name+"\n");
output.write("");

    }

}
