package org.nuiton.eugengo.generator.test;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugengo.generator.DaoCommonGenerator;

public class DaoTestGenerator extends DaoCommonGenerator {

    @Override
    public String getFilenameForClass(ObjectModelClass clazz) {
        String fqn = getQualifiedName(clazz);
        return fqn.replace('.', File.separatorChar) + ".java";
    }

    public static String getPackageName(ObjectModelClass clazz) {
        String result = clazz.getPackageName();
        result = result.replace(".entities", ".daos");
        return result;
    }

    public static String getQualifiedName(ObjectModelClass clazz) {
        return getPackageName(clazz) + "." + getClassName(clazz);
    }

    public static String getClassName(ObjectModelClass clazz) {
        return clazz.getName() + "DaoTest";
    }

    protected void generateFromEntity(Writer output, ObjectModelClass entityClazz, ObjectModelClassifier daoClazz) throws IOException {

        generateCopyright(output);

        String packageName = getPackageName(entityClazz);
        String name = getClassName(entityClazz);
        String entityFqn = entityClazz.getQualifiedName();
        String entityName = entityClazz.getName();
output.write("package "+packageName+";\n");
output.write("\n");
output.write("");

        clearImports();
        addImport("org.sharengo.orm.DAO");
        addImport(List.class);
        lookForAttributeImports(entityClazz);
        if (daoClazz != null) {
            lookForOperationImports(daoClazz);
        }
        addImport(entityFqn);
        generateImports(output, packageName);

output.write("/**\n");
output.write(" * DAO test interface for "+entityName+".\n");
output.write(" */\n");
output.write("public interface "+name+" extends DAO<"+entityName+"> {\n");
output.write("\n");
output.write("    /*\n");
output.write("     * Generated methods\n");
output.write("     */\n");
output.write("");

        String entityType = getType(entityFqn);
        for (ObjectModelAttribute attr : entityClazz.getAttributes()) {
            if (attr.isNavigable() && (attr.getStereotypes() == null || attr.getStereotypes().isEmpty())) {
                String attrName = attr.getName();
output.write("    // findBy \""+attrName+"\" methods\n");
output.write("");
                generateFindByPropertyHeader(output, entityType, attr, true);
                generateFindAllByPropertyHeader(output, entityType, attr, true, false);
                generateFindAllByPropertyHeader(output, entityType, attr, true, true);
            }
        }

        if (daoClazz != null) {
output.write("    /*\n");
output.write("     * Dao defined methods\n");
output.write("     */\n");
output.write("");
            for (ObjectModelOperation op : daoClazz.getOperations()) {
                generateOperationHeader(output, op, true);
            }
        }

output.write("} //"+name+"\n");
output.write("");

    }

}
