package org.nuiton.eugengo.generator.spring;

import java.io.File;
import java.io.IOException;
import java.io.Writer;

import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugengo.EugengoUtils;
import org.nuiton.eugengo.generator.ServiceGenerator;
import org.nuiton.eugengo.generator.WikengoCommonGenerator;

public class HessianXmlGenerator extends WikengoCommonGenerator {

    public String getFilenameForModel(ObjectModel model) {
        String modelName = EugengoUtils.extractModelName(model);
        String fileName = "META-INF" + File.separatorChar +
                "spring" + File.separatorChar + 
                modelName + File.separatorChar + 
                "layer-hessian-services.xml";
        return fileName;
    }

    public void generateFromModel(Writer output, ObjectModel model)
            throws IOException {
    	boolean generate = false;
    	for (ObjectModelClass clazz : model.getClasses()) {
            if (EugengoUtils.isService(clazz)) {
            	generate = true;
            	break;
            }
        }
    	if (!generate) {
    		return;
    	}

output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
output.write("<beans xmlns=\"http://www.springframework.org/schema/beans\"\n");
output.write("    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
output.write("    xmlns:aop=\"http://www.springframework.org/schema/aop\"\n");
output.write("    xmlns:tx=\"http://www.springframework.org/schema/tx\"\n");
output.write("    xmlns:jee=\"http://www.springframework.org/schema/jee\"\n");
output.write("    xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-2.0.xsd\n");
output.write("           http://www.springframework.org/schema/aop http://www.springframework.org/schema/aop/spring-aop-2.0.xsd\n");
output.write("           http://www.springframework.org/schema/tx http://www.springframework.org/schema/tx/spring-tx-2.0.xsd\n");
output.write("           http://www.springframework.org/schema/jee http://www.springframework.org/schema/jee/spring-jee-2.0.xsd\">\n");
output.write("\n");
output.write("    <!--\n");
output.write("    <aop:config>          \n");
output.write("        <aop:advisor advice-ref=\"hibernateInterceptor\" pointcut=\"execution(* org.springframework.remoting.caucho.HessianServiceExporter.handleRequest(..))\" order=\"1\"/>\n");
output.write("    </aop:config>\n");
output.write("    -->\n");
output.write("\n");
output.write("");
        for (ObjectModelClass clazz : model.getClasses()) {
//        	if (EugengoUtils.isWebService(clazz)) {
            if (EugengoUtils.isService(clazz)) {
                String springName = EugengoUtils.toLowerCaseFirstLetter(clazz.getName());
                String name = ServiceGenerator.getClassName(clazz);
                String wsFqn = ServiceGenerator.getQualifiedName(clazz);
output.write("    <bean name=\"/"+name+"\" class=\"org.springframework.remoting.caucho.HessianServiceExporter\">\n");
output.write("        <property name=\"service\" ref=\""+springName+"\"/>\n");
output.write("        <property name=\"serviceInterface\" value=\""+wsFqn+"\"/>\n");
output.write("        <property name=\"sendCollectionType\" value=\"false\"/>\n");
output.write("    </bean>\n");
output.write("\n");
output.write("");
            }
        }
output.write("    <bean class=\"org.springframework.web.servlet.handler.SimpleUrlHandlerMapping\">            \n");
output.write("        <property name=\"urlMap\">\n");
output.write("            <map>\n");
output.write("");
        for (ObjectModelClass clazz : model.getClasses()) {
//            if (EugengoUtils.isWebService(clazz)) {:
            if (EugengoUtils.isService(clazz)) {
                String name = ServiceGenerator.getClassName(clazz);
output.write("                <entry key=\"/"+name+"\">\n");
output.write("                    <ref bean=\"/"+name+"\"/>\n");
output.write("                </entry>\n");
output.write("");
            }
        }
output.write("            </map>\n");
output.write("        </property>\n");
output.write("    </bean>\n");
output.write("\n");
output.write("");

output.write("</beans>\n");
output.write("");
    }
}
