package org.nuiton.eugengo.generator.spring;

import java.io.File;
import java.io.IOException;
import java.io.Writer;

import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugengo.EugengoUtils;
import org.nuiton.eugengo.generator.DaoAbstractGenerator;
import org.nuiton.eugengo.generator.WikengoCommonGenerator;

public class DaoXmlGenerator extends WikengoCommonGenerator {

    public String getFilenameForModel(ObjectModel model) {
        String modelName = EugengoUtils.extractModelName(model);
        String fileName = "META-INF" + File.separatorChar +
                "spring" + File.separatorChar + 
                modelName + File.separatorChar + 
                "layer-daos-hibernate.xml";
        return fileName;
    }

    public void generateFromModel(Writer output, ObjectModel model)
            throws IOException {
output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
output.write("\n");
output.write("<beans xmlns=\"http://www.springframework.org/schema/beans\"\n");
output.write("    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
output.write("    xmlns:jee=\"http://www.springframework.org/schema/jee\"\n");
output.write("    xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-2.0.xsd\n");
output.write("           http://www.springframework.org/schema/jee http://www.springframework.org/schema/jee/spring-jee-2.0.xsd\">\n");
output.write("\n");
output.write("");
        for (ObjectModelClass clazz : model.getClasses()) {
            if (EugengoUtils.isDao(clazz)) {
                String name = clazz.getName();
                String iocName = EugengoUtils.toLowerCaseFirstLetter(name);
                String defaultImpl = DaoAbstractGenerator.getQualifiedName(clazz);
output.write("    <bean id=\""+iocName+"\" class=\""+defaultImpl+"\">\n");
output.write("        <property name=\"sessionFactory\" ref=\"sessionFactory\"/>\n");
output.write("    </bean>\n");
output.write("\n");
output.write("");
            }
        }

output.write("</beans>\n");
output.write("");
    }
}
