package org.nuiton.eugengo.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelDependency;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugengo.EugengoUtils;

public class ServiceRemoteGenerator extends WikengoCommonGenerator {

    private final static Log log = LogFactory.getLog(ServiceRemoteGenerator.class);

    @Override
    public String getFilenameForClass(ObjectModelClass clazz) {
        String fqn = getQualifiedName(clazz);
        return fqn.replace('.', File.separatorChar) + ".java";
    }

    public static String getQualifiedName(ObjectModelClass clazz) {
        return getPackageName(clazz) + "." + getClassName(clazz);
    }

    public static String getPackageName(ObjectModelClass clazz) {
        return clazz.getPackageName();
    }

    public static String getClassName(ObjectModelClass clazz) {
        return clazz.getName() + "WebService";
    }

    public void generateFromClass(Writer output, ObjectModelClass clazz)
            throws IOException {
        if (!EugengoUtils.isWebService(clazz)) {
            return;
        }

        //Crud specific (look for the crud dto)
        boolean isCrud = EugengoUtils.isCrudService(clazz);
        String crudDtoFqn = null;
        if (isCrud) {

            ObjectModelClassifier dto = null;
            for (ObjectModelDependency dependency : clazz.getDependencies()) {
                if (dependency.getSupplier() != null && EugengoUtils.isDto(dependency.getSupplier())) {
                    dto = dependency.getSupplier();
                }
            }
            if (dto == null) {
                log.error("missing dto dependency: " + clazz.getQualifiedName());
                return;
            }

            crudDtoFqn = dto.getQualifiedName();
        }

        generateCopyright(output);

        String packageName = getPackageName(clazz);
        String name = getClassName(clazz);
output.write("package "+packageName+";\n");
output.write("\n");
output.write("");

        String technicalExceptionClass = "org.sharengo.exceptions.TechnicalException";

        clearImports();
        if (isCrud) {
            addImport("org.sharengo.utils.utils.services.ICrudSrv");
            addImport(crudDtoFqn);
        }
        addImport(technicalExceptionClass);
        lookForOperationImports(clazz);
        generateImports(output, packageName);

        String crudExtension = "";
        if (isCrud) {
            crudExtension = "extends ICrudSrv<" + getType(crudDtoFqn) + "> ";
        }
        generateClazzDocumentation(output, clazz);
output.write("public interface "+name+" "+crudExtension+"{\n");
output.write("\n");
output.write("");

        for (ObjectModelOperation op : clazz.getOperations()) {
            if (EugengoUtils.isRemote(op)) {
                generateOperationHeader(output, op, true, technicalExceptionClass);
            }
        }
output.write("} //"+name+"\n");
output.write("");

    }

}
