package org.nuiton.eugengo.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelDependency;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugengo.EugengoUtils;

public class ServiceGenerator extends WikengoCommonGenerator {

    private final static Log log = LogFactory.getLog(ServiceGenerator.class);

    @Override
    public String getFilenameForClassifier(ObjectModelClassifier clazz) {
        String fqn = getQualifiedName(clazz);
        return fqn.replace('.', File.separatorChar) + ".java";
    }

    public static String getQualifiedName(ObjectModelClassifier clazz) {
        return getPackageName(clazz) + "." + getClassName(clazz);
    }

    public static String getPackageName(ObjectModelClassifier clazz) {
        return clazz.getPackageName();
    }

    public static String getClassName(ObjectModelClassifier clazz) {
        return clazz.getName();
    }

    @Override
    public void generateFromClassifier(Writer output,
            ObjectModelClassifier clazz) throws IOException {
        if (!EugengoUtils.isService(clazz)) {
            return;
        }

        //Crud specific (look for the crud dto)
        boolean isCrud = EugengoUtils.isCrudService(clazz);
        String crudDtoFqn = null;
        if (isCrud) {

            ObjectModelClassifier dto = null;
            for (ObjectModelDependency dependency : clazz.getDependencies()) {
                if (dependency.getSupplier() != null && EugengoUtils.isDto(dependency.getSupplier())) {
                    dto = dependency.getSupplier();
                }
            }
            if (dto == null) {
                log.error("missing dto dependency: " + clazz.getQualifiedName());
                return;
            }

            crudDtoFqn = dto.getQualifiedName();
        }

        generateCopyright(output);

        String packageName = clazz.getPackageName();
        String name = clazz.getName();
output.write("package "+packageName+";\n");
output.write("\n");
output.write("");

        String technicalExceptionClass = "org.sharengo.exceptions.TechnicalException";

        clearImports();
        if (isCrud) {
            addImport("org.sharengo.utils.utils.services.ICrudSrv");
            addImport(crudDtoFqn);
        }
        if (clazz instanceof ObjectModelClass) {
            lookForStaticAttributeImports((ObjectModelClass)clazz);
        }
        lookForOperationImports(clazz);
        addImport(technicalExceptionClass);
        generateImports(output, packageName);

        String crudExtension = "";
        if (isCrud) {
            crudExtension = "extends ICrudSrv<" + getType(crudDtoFqn) + "> ";
        }
        generateClazzDocumentation(output, clazz);
output.write("public interface "+name+" "+crudExtension+"{\n");
output.write("\n");
output.write("");

        if (clazz instanceof ObjectModelClass) {
            generateStaticAttributes(output, (ObjectModelClass)clazz);
        }

        for (ObjectModelOperation op : clazz.getOperations()) {
            generateOperationHeader(output, op, true, technicalExceptionClass);
        }
output.write("} //"+name+"\n");
output.write("");

    }

}
