package org.nuiton.eugengo.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;

import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugengo.EugengoUtils;

public class ExceptionGenerator extends WikengoCommonGenerator {

    @Override
    public String getFilenameForClass(ObjectModelClass clazz) {
        String fqn = clazz.getQualifiedName();
        return fqn.replace('.', File.separatorChar) + ".java";
    }

    public void generateFromClass(Writer output, ObjectModelClass clazz)
            throws IOException {
        if (!EugengoUtils.isException(clazz)) {
            return;
        }

        generateCopyright(output);

        String packageName = clazz.getPackageName();
        String name = clazz.getName();
output.write("package "+packageName+";\n");
output.write("\n");
output.write("");

        ObjectModelClass superClass = findSuperClass(clazz);

        clearImports();
        lookForAttributeImports(clazz);
        addImport(superClass);
        if (EugengoUtils.isBusinessException(clazz) && superClass == null) {
            addImport("org.sharengo.exceptions.BusinessException");
        }
        generateImports(output, packageName);

        generateClazzDocumentation(output, clazz);
        String extendsString = "Exception";
        if (EugengoUtils.isBusinessException(clazz)) {
            extendsString = getType("org.sharengo.exceptions.BusinessException");
        }
        if (superClass != null) {
            extendsString = getType(superClass.getQualifiedName());
        }
output.write("public class "+name+" extends "+extendsString+" {\n");
output.write("\n");
output.write("");

        String svUID = GeneratorUtil.computeSerialVersionUID(clazz);
output.write("    private static final long serialVersionUID = "+svUID+";\n");
output.write("\n");
output.write("");

        generateStaticAttributes(output, clazz);

        generateExceptionConstructors(output, clazz);

        generateAttributesDeclaration(output, clazz);

        generateAttributesAccessors(output, clazz);

output.write("} //"+name+"\n");
output.write("");

    }

}
