package org.nuiton.eugengo.generator;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;

import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugengo.EugengoUtils;

public class EntityGenerator extends WikengoCommonGenerator {

    @Override
    public String getFilenameForClass(ObjectModelClass clazz) {
        String fqn = clazz.getQualifiedName();
        return fqn.replace('.', File.separatorChar) + ".java";
    }

    public void generateFromClass(Writer output, ObjectModelClass clazz)
            throws IOException {
        // Generate only is clazz has the stereotye "entity"
        if (!EugengoUtils.isEntity(clazz)) {
            return;
        }

        generateCopyright(output);

        String packageName = clazz.getPackageName();
        String name = clazz.getName();
output.write("package "+packageName+";\n");
output.write("\n");
output.write("");

        ObjectModelClass superClass = findSuperClass(clazz);

        clearImports();
        addImport(Serializable.class);
        addImport(superClass);
        lookForAttributeImports(clazz);
        generateImports(output, packageName);

        generateClazzDocumentation(output, clazz);
        String extendsString = "";
        if (superClass != null) {
            extendsString = " extends " + getType(superClass.getQualifiedName());
        }
        String abstractString = "";
        if (clazz.isAbstract()) {
            abstractString += "abstract ";
        }
output.write("public "+abstractString+"class "+name+""+extendsString+" implements Serializable {\n");
output.write("\n");
output.write("");

        String svUID = GeneratorUtil.computeSerialVersionUID(clazz);
output.write("    private static final long serialVersionUID = "+svUID+";\n");
output.write("\n");
output.write("");

        generateStaticAttributes(output, clazz);

        generatePropertyConstant(output, "id");
        generatePropertiesConstant(output, clazz);

output.write("    /**\n");
output.write("     * Automatic primary key.\n");
output.write("     */\n");
output.write("    protected String id;\n");
output.write("\n");
output.write("");

        generateAttributesDeclaration(output, clazz);

output.write("    // Accessors for primary key\n");
output.write("    public void setId(String id) {\n");
output.write("        this.id = id;\n");
output.write("    }\n");
output.write("\n");
output.write("    public String getId() {\n");
output.write("        return this.id;\n");
output.write("    }\n");
output.write("\n");
output.write("");

        generateAttributesAccessors(output, clazz);

        generateHashCode(output, clazz);

output.write("    public boolean equals(Object other) {\n");
output.write("        if (other == null) {\n");
output.write("            return false;\n");
output.write("        }\n");
output.write("        if (!(other instanceof "+name+")) {\n");
output.write("            return false;\n");
output.write("        }\n");
output.write("        if (id == null) {\n");
output.write("            return (("+name+")other).getId() == null;\n");
output.write("        }\n");
output.write("        return id.equals((("+name+")other).getId());\n");
output.write("    }\n");
output.write("\n");
output.write("    public String toString() {\n");
output.write("        return this.getClass().getName() + \"[id=\" + id + \"]\";\n");
output.write("    }\n");
output.write("\n");
output.write("} //"+name+"\n");
output.write("");
    }

    protected void generatePropertiesConstant(Writer output, ObjectModelClass clazz) throws IOException {
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (attr.isNavigable() && !attr.isStatic() && (attr.getStereotypes() == null || attr.getStereotypes().isEmpty())) {
                generatePropertyConstant(output, attr.getName());                
            }
        }
    }

    protected void generatePropertyConstant(Writer output, String propertyName)
        throws IOException {
        String constantName = propertyName.toUpperCase();
output.write("    /**\n");
output.write("     * Constant representing the name of the field \""+propertyName+"\".\n");
output.write("     */\n");
output.write("    public static final String PROP_"+constantName+" = \""+propertyName+"\";\n");
output.write("\n");
output.write("");
    }

}
