package org.nuiton.eugengo.generator;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;

import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugengo.EugengoUtils;

public class DtoGenerator extends WikengoCommonGenerator {

    @Override
    public String getFilenameForClass(ObjectModelClass clazz) {
        String fqn = clazz.getQualifiedName();
        return fqn.replace('.', File.separatorChar) + ".java";
    }

    public void generateFromClass(Writer output, ObjectModelClass clazz)
            throws IOException {
        if (!EugengoUtils.isDto(clazz)) {
            return;
        }

        generateCopyright(output);

        String packageName = clazz.getPackageName();
        String name = clazz.getName();
output.write("package "+packageName+";\n");
output.write("\n");
output.write("");
        ObjectModelClass superClass = findSuperClass(clazz);

        clearImports();
        addImport(Serializable.class);
        addImport(superClass);
        lookForAttributeImports(clazz);
        generateImports(output, packageName);

        generateClazzDocumentation(output, clazz);
        String extendsString = "";
        if (superClass != null) {
            extendsString = " extends " + getType(superClass.getQualifiedName());
        }
        String abstractString = "";
        if (clazz.isAbstract()) {
            abstractString += "abstract ";
        }
output.write("public "+abstractString+"class "+name+""+extendsString+" implements Serializable {\n");
output.write("\n");
output.write("");

        String svUID = GeneratorUtil.computeSerialVersionUID(clazz);
output.write("    private static final long serialVersionUID = "+svUID+";\n");
output.write("\n");
output.write("");

        generateStaticAttributes(output, clazz);

        generateAttributesDeclaration(output, clazz);

        generateDefaultConstructor(output, name);
        generateFullConstructor(output, name, clazz.getAttributes());

        generateAttributesAccessors(output, clazz);

        generateHashCode(output, clazz);

output.write("} //"+name+"\n");
output.write("");

    }

}
