package org.nuiton.eugengo.generator;

import java.io.IOException;
import java.io.Writer;

import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelDependency;
import org.nuiton.eugengo.EugengoConstants;
import org.nuiton.eugengo.EugengoUtils;

public abstract class DaoCommonGenerator extends WikengoCommonGenerator {

    public void generateFromClass(Writer output, ObjectModelClass clazz)
            throws IOException {
        // Generate a dao for each entity
        if (!EugengoUtils.isEntity(clazz)) {
            return;
        }

        // look for a daoClass that may contain additional operations
        ObjectModelClassifier daoClass = findClassWithStereotypeAndDependency(model, clazz, EugengoConstants.STEREOTYPE_DAO);

        generateFromEntity(output, clazz, daoClass);
    }

    protected abstract void generateFromEntity(Writer output, ObjectModelClass entityClazz, ObjectModelClassifier daoClazz) throws IOException;

    protected ObjectModelClassifier findClassWithStereotypeAndDependency(ObjectModel model, ObjectModelClass clazz, String stereotype) {
        // loop over classifiers
        for (ObjectModelClassifier classifier : model.getClassifiers()) {
            // check stereotype
            if (EugengoUtils.hasStereotype(classifier, stereotype)) {
                // loop over dependencies
                for (ObjectModelDependency dependency : classifier.getDependencies()) {
                    // check if dependency is the one searched
                    if (dependency.getSupplier() != null && clazz.equals(dependency.getSupplier())) {
                        return classifier;
                    }
                }
            }
        }
        return null;
    }

    protected void generateFindByPropertyHeader(Writer output, String entityType,
            ObjectModelAttribute attr, boolean generateForInterface)
             throws IOException {
        String attrName = EugengoUtils.toUpperCaseFirstLetter(attr.getName());
        String attrVarName = EugengoUtils.toLowerCaseFirstLetter(attr.getName());
        String attrType = getType(attr.getType());
        String visibility = "";
        if (!generateForInterface) {
            visibility = "public ";
        }
output.write("    "+visibility+""+entityType+" findBy"+attrName+"("+attrType+" "+attrVarName+")");
        if (generateForInterface) {
output.write(";\n");
output.write("\n");
output.write("");
        } else {
output.write(" {\n");
output.write("");
        }
    }

    protected void generateFindAllByPropertyHeader(Writer output, String entityType,
            ObjectModelAttribute attr, boolean generateForInterface, boolean withPagination)
            throws IOException {
        String attrName = EugengoUtils.toUpperCaseFirstLetter(attr.getName());
        String attrVarName = EugengoUtils.toLowerCaseFirstLetter(attr.getName());
        String attrType = getType(attr.getType());
        String visibility = "";
        String listType = "List";
        String paginationParameters = "";
        if (withPagination) {
        	listType = "PagedResult";
        	paginationParameters = ", int start, int end";
        }
        if (!generateForInterface) {
            visibility = "public ";
        }
output.write("    "+visibility+""+listType+"<"+entityType+"> findAllBy"+attrName+"("+attrType+" "+attrVarName+""+paginationParameters+")");
        if (generateForInterface) {
output.write(";\n");
output.write("\n");
output.write("");
        } else {
output.write(" {\n");
output.write("");
        }
    }

}
