package org.nuiton.eugengo.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugengo.EugengoUtils;

public class DaoAbstractGenerator extends DaoCommonGenerator {

    @Override
    public String getFilenameForClass(ObjectModelClass clazz) {
        String fqn = getQualifiedName(clazz);
        return fqn.replace('.', File.separatorChar) + ".java";
    }

    public static String getQualifiedName(ObjectModelClass clazz) {
        return getPackageName(clazz) + "." + getClassName(clazz);
    }

    private static String getClassName(ObjectModelClass clazz) {
        return "Abstract" + clazz.getName() + "Dao";
    }

    private static String getPackageName(ObjectModelClass clazz) {
        return DaoGenerator.getPackageName(clazz) + ".impl";
    }

    @Override
    protected void generateFromEntity(Writer output,
            ObjectModelClass entityClazz, ObjectModelClassifier daoClazz)
            throws IOException {

        generateCopyright(output);

        String packageName = getPackageName(entityClazz);
        String name = getClassName(entityClazz);
        String entityFqn = entityClazz.getQualifiedName();
        String entityName = entityClazz.getName();
        String parentInterface = DaoGenerator.getQualifiedName(entityClazz);
output.write("package "+packageName+";\n");
output.write("\n");
output.write("");

        clearImports();
        lookForAttributeImports(entityClazz);
        addImport("org.sharengo.orm.hibernate.AbstractHibernateDAO");
        addImport("org.sharengo.dtos.PagedResult");
        addImport(entityFqn);
        if (hasNavigableAndNonStaticAttributes(entityClazz)) {
            addImport(List.class);
        }
        addImport(parentInterface); //Import the corresponding interface
        generateImports(output, packageName);

        String entityType = getType(entityFqn);
        String extension = "extends AbstractHibernateDAO<" + entityType + "> implements " + getType(parentInterface);
output.write("/*\n");
output.write(" * DAO abstract implementation for "+entityName+"\n");
output.write(" */\n");
output.write("public abstract class "+name+" "+extension+" {\n");
output.write("\n");
output.write("    @Override\n");
output.write("    protected Class<"+entityType+"> getEntity() {\n");
output.write("        return "+entityType+".class;\n");
output.write("    }\n");
output.write("\n");
output.write("");

        for (ObjectModelAttribute attr : entityClazz.getAttributes()) {
            if (attr.isNavigable() && (attr.getStereotypes() == null || attr.getStereotypes().isEmpty())) {
                String attrName = attr.getName();
output.write("    // findBy \""+attrName+"\" methods\n");
output.write("");
                String attrConstantName = attrName.toUpperCase();
                String attrVarName = EugengoUtils.toLowerCaseFirstLetter(attrName);

                generateFindByPropertyHeader(output, entityType, attr, false);
output.write("        return super.findByProperty("+entityType+".PROP_"+attrConstantName+", "+attrVarName+");\n");
output.write("    }\n");
output.write("\n");
output.write("");
                generateFindAllByPropertyHeader(output, entityType, attr, false, false);
output.write("        return super.findAllByProperty("+entityType+".PROP_"+attrConstantName+", "+attrVarName+", 0, -1).getList();\n");
output.write("    }\n");
output.write("\n");
output.write("");

                generateFindAllByPropertyHeader(output, entityType, attr, false, true);
output.write("        return super.findAllByProperty("+entityType+".PROP_"+attrConstantName+", "+attrVarName+", start, end);\n");
output.write("    }\n");
output.write("\n");
output.write("");
            }
        }

output.write("} //"+name+"\n");
output.write("");

    }

}
