package org.nuiton.eugengo.generator;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugengo.EugengoUtils;

/**
 * Generate pure Bean Object (no wikitty object internaly stored)
 *
 * @author poussin
 */
public class BusinessEntityBeanGenerator extends WikengoCommonGenerator {
	
	private static final Log log = LogFactory.getLog(BusinessEntityBeanGenerator.class);

    protected String EXT_NAME;

    /**
     * A flag to generate on setter a propertyChangeEvent.
     */
    protected Boolean generatePropertyChangeListener;

    @Override
    public String getFilenameForClass(ObjectModelClass clazz) {
        String fqn = clazz.getQualifiedName();
        log.info( "Filename for " + clazz.getName() + " is " +  fqn.replace('.', File.separatorChar) + ".java");
        return fqn.replace('.', File.separatorChar) + "Bean.java";
    }

    public void generateFromClass(Writer output, ObjectModelClass clazz)
            throws IOException {
        if (!EugengoUtils.isBusinessEntity(clazz)) {
        	log.info( clazz.getName() + " is not a business entity");
            return;
        }

        log.info("Generate Bean Business entity " + clazz.getName() + "... ");
        String genPCS = EugengoUtils.findTagValue("generatePropertyChangeListener",clazz,model);
        generatePropertyChangeListener = genPCS != null && "true".equals(genPCS.trim());

        generateCopyright(output);

        String packageName = clazz.getPackageName();
        String name = clazz.getName() + "Bean";
output.write("package "+packageName+";\n");
output.write("\n");
output.write("");
        ObjectModelClass superClass = findSuperClass(clazz);

        clearImports();
        addImport(clazz);
        addImport(superClass);
        addImport("org.sharengo.wikitty.BusinessEntityBean");
        String parentBean = null;
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (EugengoUtils.isBusinessEntity(parent)) {
                addImport(parent);
                parentBean = parent.getQualifiedName() + "Bean"; 
                addImport( parentBean );
            }
        }
        if (generatePropertyChangeListener) {
            addImport(PropertyChangeSupport.class.getName());
            addImport(PropertyChangeListener.class.getName());
        }
        lookForAttributeImports(clazz);
        generateImports(output, packageName);

        generateClazzDocumentation(output, clazz);
        String extendsString = " extends " + ( parentBean != null ? parentBean : getType("org.sharengo.wikitty.BusinessEntityBean") );
        String abstractString = "";
        if (clazz.isAbstract()) {
            abstractString += "abstract ";
        }

        String implementsString = "implements " + getType(clazz.getQualifiedName());
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (EugengoUtils.isBusinessEntity(parent)) {
                implementsString += ", " + getType(parent.getQualifiedName());
            }
        }

output.write("public "+abstractString+"class "+name+""+extendsString+" "+implementsString+" {\n");
output.write("\n");
output.write("");

        String svUID = GeneratorUtil.computeSerialVersionUID(clazz);
output.write("    private static final long serialVersionUID = "+svUID+";\n");
output.write("\n");
output.write("    public "+name+"() {\n");
output.write("        super();\n");
output.write("    }\n");
output.write("\n");
output.write(" ");
        if (generatePropertyChangeListener) {

output.write("    protected PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);\n");
output.write("\n");
output.write("    public void addPropertyChangeListener(PropertyChangeListener listener) {\n");
output.write("		propertyChange.addPropertyChangeListener(listener);\n");
output.write("	}\n");
output.write("\n");
output.write("	public void removePropertyChangeListener(PropertyChangeListener listener) {\n");
output.write("		propertyChange.removePropertyChangeListener(listener);\n");
output.write("	}\n");
output.write("\n");
output.write("	public void addPropertyChangeListener(String propertyName,PropertyChangeListener listener) {\n");
output.write("		propertyChange.addPropertyChangeListener(propertyName, listener);\n");
output.write("	}\n");
output.write("\n");
output.write("	public void removePropertyChangeListener(String propertyName,PropertyChangeListener listener) {\n");
output.write("		propertyChange.removePropertyChangeListener(propertyName, listener);\n");
output.write("	}\n");
output.write("\n");
output.write("");
        }
        generateFieldAndMethod(output, clazz);
        
output.write("\n");
output.write("} //"+name+"\n");
output.write("");

    }
    
    
    
    // Utilitarian methods

    private void generateFieldAndMethod(Writer output,
            ObjectModelClass clazz) throws IOException {
        generateWikittyField(output, clazz);
        generateAttributeAccessMethod(output, clazz);

        // we must generate method for parent of parent
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (EugengoUtils.isBusinessEntity(parent)) {
                generateFieldAndMethod(output, parent);
            }
        }

    }


    private void generateWikittyField(Writer output,
            ObjectModelClass clazz) throws IOException {

    	for (ObjectModelAttribute attr : clazz.getAttributes()) {
    		if (attr.isNavigable() && !attr.isStatic() &&
                    (attr.getStereotypes() == null || attr.getStereotypes().isEmpty())) {
    			generateAttribute(output, attr);
    		}
    	}
    }

    private void generateAttributeAccessMethod(Writer output, ObjectModelClass clazz) throws IOException {
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (attr.isNavigable() && !attr.isStatic()
                    && (attr.getStereotypes() == null || attr.getStereotypes().isEmpty())) {
        		if ((attr.getMaxMultiplicity() != 0 && attr.getMaxMultiplicity() != 1)) {
        			//TODO ymartel 20090812: when dataType "List", "Set" or "Collection" in model, must be here!
        			generateCollectionAttributeAccessors(output, attr);
        		} else {
        			generateWikittyAttributeAccessors(output, attr);
        		}
            }
        }
    }

    private void generateAttribute(Writer output, ObjectModelAttribute attr)
            throws IOException {
        EXT_NAME = attr.getDeclaringElement().getName();

        String attrType = computeType(attr);
        if (EugengoUtils.notEmpty(attrType)) {
            attrType = getType(attrType, true);
        } else {
            return;
        }

        String attrName = EXT_NAME + "$" + attr.getName();
output.write("    public "+attrType+" "+attrName+";\n");
output.write("\n");
output.write(" ");
    }
    
    private void generateWikittyAttributeAccessors(Writer output,
    		ObjectModelAttribute attr) throws IOException {

        EXT_NAME = attr.getDeclaringElement().getName();

        String attrType = computeType(attr);
    	if (EugengoUtils.notEmpty(attrType)) {
    		attrType = getType(attrType, true);
    	} else {
    		return;
    	}
    	
        String simpleAttrName = attr.getName();
    	String attrNameCapitalized = EugengoUtils.toUpperCaseFirstLetter(simpleAttrName);
        String attrName = EXT_NAME + "$" + simpleAttrName;
        String genPCS = "";
        if(!generatePropertyChangeListener) {
            genPCS = "//";
        }

output.write("\n");
output.write("    public void set"+attrNameCapitalized+"("+attrType+" value) {\n");
output.write("        "+genPCS+"Object oldValue = "+attrName+"; \n");
output.write("        this."+attrName+" = value;\n");
output.write("        "+genPCS+"propertyChange.firePropertyChange(\""+simpleAttrName+"\", oldValue, value);\n");
output.write("    }\n");
output.write("\n");
output.write("    public "+attrType+" get"+attrNameCapitalized+"() {\n");
output.write("        return "+attrName+";\n");
output.write("    }\n");
output.write("\n");
output.write("");
    }

    private void generateCollectionAttributeAccessors(Writer output,
    		ObjectModelAttribute attr) throws IOException {

        EXT_NAME = attr.getDeclaringElement().getName();

        String attrType = computeType(attr);
    	if (EugengoUtils.notEmpty(attrType)) {
    		attrType = getType(attrType, true);
    	} else {
    		return;
    	}

        // get collection element type for add and remove method arguement type
        String elementType = getType(attr.getType(), true);

        String simpleAttrName = attr.getName();
    	String attrNameCapitalized = EugengoUtils.toUpperCaseFirstLetter(simpleAttrName );
        String attrName = EXT_NAME + "$" + simpleAttrName;
        String genPCS = "";
        if(!generatePropertyChangeListener) {
            genPCS = "//";
        }

output.write("    public "+attrType+" get"+attrNameCapitalized+"() {\n");
output.write("        return "+attrName+";\n");
output.write("    }\n");
output.write("\n");
output.write("    public void add"+attrNameCapitalized+"("+elementType+" element) {\n");
output.write("        "+attrName+".add(element);\n");
output.write("        "+genPCS+"propertyChange.firePropertyChange(\""+simpleAttrName+"\", null, "+attrName+");\n");
output.write("    }\n");
output.write("    \n");
output.write("    public void remove"+attrNameCapitalized+"("+elementType+" element) {\n");
output.write("        "+attrName+".remove(element);\n");
output.write("        "+genPCS+"propertyChange.firePropertyChange(\""+simpleAttrName+"\", null, "+attrName+");\n");
output.write("    }\n");
output.write("    \n");
output.write("    public void clear"+attrNameCapitalized+"() {\n");
output.write("        "+attrName+".clear();\n");
output.write("        "+genPCS+"propertyChange.firePropertyChange(\""+simpleAttrName+"\", null, "+attrName+");\n");
output.write("    }\n");
output.write("\n");
output.write("");
    }
    
    private static Set<String> commonTypes;
    static {
        commonTypes = new HashSet<String>();
        commonTypes.add("byte");
        commonTypes.add("Byte");
        commonTypes.add("short");
        commonTypes.add("Short");
        commonTypes.add("int");
        commonTypes.add("Integer");
        commonTypes.add("long");
        commonTypes.add("Long");
        commonTypes.add("float");
        commonTypes.add("Float");
        commonTypes.add("double");
        commonTypes.add("Double");

        commonTypes.add("char");
        commonTypes.add("Char");

        commonTypes.add("boolean");
        commonTypes.add("Boolean");

        commonTypes.add("Date");
        commonTypes.add("String");
    }

}
