/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.jardiff;

public final class Tools {
    private Tools() {
    }

    public static final String getClassName(String internalName) {
        StringBuffer ret = new StringBuffer(internalName.length());
        block3: for (int i = 0; i < internalName.length(); ++i) {
            char ch = internalName.charAt(i);
            switch (ch) {
                case '$': 
                case '/': {
                    ret.append('.');
                    continue block3;
                }
                default: {
                    ret.append(ch);
                }
            }
        }
        return ret.toString();
    }

    private static boolean has(int value, int mask) {
        return (value & mask) != 0;
    }

    private static boolean not(int value, int mask) {
        return (value & mask) == 0;
    }

    private static boolean isAccessIncompatible(int oldAccess, int newAccess) {
        if (Tools.has(newAccess, 1)) {
            return false;
        }
        if (Tools.has(newAccess, 4)) {
            return Tools.has(oldAccess, 1);
        }
        if (Tools.has(newAccess, 2)) {
            return Tools.not(oldAccess, 2);
        }
        return Tools.has(oldAccess, 5);
    }

    public static boolean isAccessChange(int oldAccess, int newAccess) {
        return Tools.isClassAccessChange(oldAccess, newAccess);
    }

    public static boolean isClassAccessChange(int oldAccess, int newAccess) {
        if (Tools.not(oldAccess, 1024) && Tools.has(newAccess, 1024)) {
            return true;
        }
        if (Tools.not(oldAccess, 16) && Tools.has(newAccess, 16)) {
            return true;
        }
        int compatibleChanges = 1040;
        int oldAccess2 = oldAccess & 0xFFFFFBEF;
        int newAccess2 = newAccess & 0xFFFFFBEF;
        return oldAccess2 != newAccess2;
    }

    public static boolean isFieldAccessChange(int oldAccess, int newAccess) {
        if (Tools.isAccessIncompatible(oldAccess, newAccess)) {
            return true;
        }
        if (Tools.not(oldAccess, 16) && Tools.has(newAccess, 16)) {
            return true;
        }
        int compatibleChanges = 144;
        int accessPermissions = 7;
        int oldAccess2 = oldAccess & 0xFFFFFF6F & 0xFFFFFFF8;
        int newAccess2 = newAccess & 0xFFFFFF6F & 0xFFFFFFF8;
        return oldAccess2 != newAccess2;
    }

    public static boolean isMethodAccessChange(int oldAccess, int newAccess) {
        if (Tools.isAccessIncompatible(oldAccess, newAccess)) {
            return true;
        }
        if (Tools.not(oldAccess, 1024) && Tools.has(newAccess, 1024)) {
            return true;
        }
        if (Tools.not(oldAccess, 16) && Tools.not(oldAccess, 8) && Tools.has(newAccess, 16)) {
            return true;
        }
        int compatibleChanges = 1328;
        int accessPermissions = 7;
        int oldAccess2 = oldAccess & 0xFFFFFACF & 0xFFFFFFF8;
        int newAccess2 = newAccess & 0xFFFFFACF & 0xFFFFFFF8;
        return oldAccess2 != newAccess2;
    }
}

