/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.pagefactory;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.List;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.FindBys;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;
import org.openqa.selenium.support.pagefactory.internal.LocatingElementHandler;
import org.openqa.selenium.support.pagefactory.internal.LocatingElementListHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFieldDecorator
implements FieldDecorator {
    protected ElementLocatorFactory factory;

    public DefaultFieldDecorator(ElementLocatorFactory factory) {
        this.factory = factory;
    }

    @Override
    public Object decorate(ClassLoader loader, Field field) {
        if (!WebElement.class.isAssignableFrom(field.getType()) && !this.isDecoratableList(field)) {
            return null;
        }
        ElementLocator locator = this.factory.createLocator(field);
        if (locator == null) {
            return null;
        }
        if (WebElement.class.isAssignableFrom(field.getType())) {
            return this.proxyForLocator(loader, locator);
        }
        if (List.class.isAssignableFrom(field.getType())) {
            return this.proxyForListLocator(loader, locator);
        }
        return null;
    }

    private boolean isDecoratableList(Field field) {
        if (!List.class.isAssignableFrom(field.getType())) {
            return false;
        }
        if (field.getAnnotation(FindBy.class) != null || field.getAnnotation(FindBys.class) != null) {
            return true;
        }
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            return false;
        }
        Type listType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
        return WebElement.class.equals((Object)listType);
    }

    protected WebElement proxyForLocator(ClassLoader loader, ElementLocator locator) {
        LocatingElementHandler handler = new LocatingElementHandler(locator);
        WebElement proxy = (WebElement)Proxy.newProxyInstance(loader, new Class[]{WebElement.class, WrapsElement.class, Locatable.class}, (InvocationHandler)handler);
        return proxy;
    }

    protected List<WebElement> proxyForListLocator(ClassLoader loader, ElementLocator locator) {
        LocatingElementListHandler handler = new LocatingElementListHandler(locator);
        List proxy = (List)Proxy.newProxyInstance(loader, new Class[]{List.class}, (InvocationHandler)handler);
        return proxy;
    }
}

