/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.server.CapabilitiesComparator;
import org.openqa.selenium.remote.server.DefaultDriverProvider;
import org.openqa.selenium.remote.server.DriverFactory;
import org.openqa.selenium.remote.server.DriverProvider;

public class DefaultDriverFactory
implements DriverFactory {
    private Map<Capabilities, DriverProvider> capabilitiesToDriverProvider = new ConcurrentHashMap<Capabilities, DriverProvider>();

    @Override
    public void registerDriver(Capabilities capabilities, Class<? extends WebDriver> implementation) {
        this.registerDriverProvider(capabilities, new DefaultDriverProvider(capabilities, implementation));
    }

    @Override
    public void registerDriverProvider(Capabilities capabilities, DriverProvider implementation) {
        this.capabilitiesToDriverProvider.put(capabilities, implementation);
    }

    protected Class<? extends WebDriver> getBestMatchFor(Capabilities desired) {
        return this.getProviderMatching(desired).getDriverClass();
    }

    protected DriverProvider getProviderMatching(Capabilities desired) {
        Preconditions.checkState((!this.capabilitiesToDriverProvider.isEmpty() ? 1 : 0) != 0, (String)"No drivers have been registered, will be unable to match %s", (Object[])new Object[]{desired});
        Capabilities bestMatchingCapabilities = CapabilitiesComparator.getBestMatch(desired, this.capabilitiesToDriverProvider.keySet());
        return this.capabilitiesToDriverProvider.get(bestMatchingCapabilities);
    }

    @Override
    public WebDriver newInstance(Capabilities capabilities) {
        return this.getProviderMatching(capabilities).newInstance(capabilities);
    }

    @Override
    public boolean hasMappingFor(Capabilities capabilities) {
        return this.capabilitiesToDriverProvider.containsKey(capabilities);
    }
}

