/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.xdrpc;

import com.google.common.base.Charsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.server.renderer.JsonErrorExceptionResult;
import org.openqa.selenium.remote.server.rest.Renderer;
import org.openqa.selenium.remote.server.rest.RestishHandler;

public class CrossDomainRpcRenderer
implements Renderer {
    private final String responsePropertyName;
    private final String errorPropertyName;
    private final JsonErrorExceptionResult exceptionResult;

    public CrossDomainRpcRenderer(String responsePropertyName, String errorPropertyName) {
        this.responsePropertyName = CrossDomainRpcRenderer.getPropertyName(responsePropertyName);
        this.errorPropertyName = CrossDomainRpcRenderer.getPropertyName(errorPropertyName);
        this.exceptionResult = new JsonErrorExceptionResult(errorPropertyName, responsePropertyName);
    }

    private static String getPropertyName(String propertyName) {
        return propertyName.startsWith(":") ? propertyName.substring(1) : propertyName;
    }

    public void render(HttpServletRequest request, HttpServletResponse response, RestishHandler handler) throws Exception {
        Object result = request.getAttribute(this.responsePropertyName);
        if (result == null) {
            result = request.getAttribute(this.errorPropertyName) != null ? this.exceptionResult.prepareResponseObject(request) : this.createEmtpySuccessResponse(request);
        }
        String renderedResponse = new BeanToJsonConverter().convert(result);
        byte[] data = Charsets.UTF_8.encode(renderedResponse).array();
        int length = data.length;
        while (data[length - 1] == 0) {
            --length;
        }
        response.setStatus(200);
        response.setContentType("application/json");
        response.setCharacterEncoding(Charsets.UTF_8.toString());
        response.setContentLength(length);
        response.getOutputStream().write(data);
        response.getOutputStream().flush();
    }

    private Response createEmtpySuccessResponse(HttpServletRequest request) {
        String sessionId = HttpCommandExecutor.getSessionId((String)request.getRequestURI());
        Response response = new Response();
        response.setStatus(0);
        response.setValue(null);
        response.setSessionId(sessionId != null ? sessionId : "");
        return response;
    }
}

