/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.rest;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.rest.RestishHandler;
import org.openqa.selenium.remote.server.rest.Result;
import org.openqa.selenium.remote.server.rest.ResultConfig;
import org.openqa.selenium.remote.server.rest.ResultType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlMapper {
    private final Multimap<ResultType, Result> globals = LinkedHashMultimap.create();
    private final Set<ResultConfig> configs = new LinkedHashSet<ResultConfig>();
    private final DriverSessions sessions;
    private final Logger log;

    public UrlMapper(DriverSessions sessions, Logger log) {
        this.sessions = sessions;
        this.log = log;
    }

    public ResultConfig bind(String url, Class<? extends RestishHandler> handlerClazz) {
        ResultConfig existingConfig = this.getConfig(url);
        if (existingConfig != null) {
            this.configs.remove(existingConfig);
        }
        ResultConfig config = new ResultConfig(url, handlerClazz, this.sessions, this.log);
        this.configs.add(config);
        Map map = this.globals.asMap();
        for (Map.Entry entry : map.entrySet()) {
            for (Result result : (Collection)entry.getValue()) {
                config.on((ResultType)((Object)entry.getKey()), result);
            }
        }
        return config;
    }

    public ResultConfig getConfig(String url) {
        for (ResultConfig config : this.configs) {
            if (!config.isFor(url)) continue;
            return config;
        }
        return null;
    }

    public void addGlobalHandler(ResultType type, Result result) {
        this.globals.put((Object)type, (Object)result);
        for (ResultConfig config : this.configs) {
            config.on(type, result);
        }
    }
}

