/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.DetachedShadowRootException;
import org.openqa.selenium.ElementClickInterceptedException;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.InsecureCertificateException;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.InvalidCookieDomainException;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchCookieException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.NoSuchShadowRootException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.ScriptTimeoutException;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.UnableToSetCookieException;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.interactions.MoveTargetOutOfBoundsException;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.InvalidResponseException;
import org.openqa.selenium.remote.ScreenshotException;

public class ErrorCodec {
    private static final W3CError<WebDriverException> DEFAULT_ERROR = new W3CError("unknown error", WebDriverException::new, 500, new WebDriverException[0]);
    private static final List<W3CError<? extends WebDriverException>> ERRORS = List.of(new W3CError("script timeout", ScriptTimeoutException::new, 500, (WebDriverException[])new ScriptTimeoutException[0]), new W3CError("detached shadow root", DetachedShadowRootException::new, 404, (WebDriverException[])new DetachedShadowRootException[0]), new W3CError("element click intercepted", ElementClickInterceptedException::new, 400, (WebDriverException[])new ElementClickInterceptedException[0]), new W3CError("element not interactable", ElementNotInteractableException::new, 400, (WebDriverException[])new ElementNotInteractableException[0]), new W3CError("invalid argument", InvalidArgumentException::new, 400, (WebDriverException[])new InvalidArgumentException[0]), new W3CError("invalid cookie domain", InvalidCookieDomainException::new, 400, (WebDriverException[])new InvalidCookieDomainException[0]), new W3CError("invalid element state", InvalidElementStateException::new, 400, (WebDriverException[])new InvalidElementStateException[0]), new W3CError("invalid selector", InvalidSelectorException::new, 400, (WebDriverException[])new InvalidSelectorException[0]), new W3CError("invalid session id", NoSuchSessionException::new, 404, (WebDriverException[])new NoSuchSessionException[0]), new W3CError("insecure certificate", InsecureCertificateException::new, 400, (WebDriverException[])new InsecureCertificateException[0]), new W3CError("javascript error", JavascriptException::new, 500, (WebDriverException[])new JavascriptException[0]), new W3CError("move target out of bounds", MoveTargetOutOfBoundsException::new, 500, (WebDriverException[])new MoveTargetOutOfBoundsException[0]), new W3CError("no such alert", NoAlertPresentException::new, 404, (WebDriverException[])new NoAlertPresentException[0]), new W3CError("no such cookie", NoSuchCookieException::new, 404, (WebDriverException[])new NoSuchCookieException[0]), new W3CError("no such element", NoSuchElementException::new, 404, (WebDriverException[])new NoSuchElementException[0]), new W3CError("no such frame", NoSuchFrameException::new, 404, (WebDriverException[])new NoSuchFrameException[0]), new W3CError("no such shadow root", NoSuchShadowRootException::new, 404, (WebDriverException[])new NoSuchShadowRootException[0]), new W3CError("no such window", NoSuchWindowException::new, 404, (WebDriverException[])new NoSuchWindowException[0]), new W3CError("session not created", SessionNotCreatedException::new, 500, (WebDriverException[])new SessionNotCreatedException[0]), new W3CError("stale element reference", StaleElementReferenceException::new, 404, (WebDriverException[])new StaleElementReferenceException[0]), new W3CError("timeout", TimeoutException::new, 500, (WebDriverException[])new TimeoutException[0]), new W3CError("unable to capture screen", ScreenshotException::new, 500, (WebDriverException[])new ScreenshotException[0]), new W3CError("unable to set cookie", UnableToSetCookieException::new, 500, (WebDriverException[])new UnableToSetCookieException[0]), new W3CError("unexpected alert open", UnhandledAlertException::new, 500, (WebDriverException[])new UnhandledAlertException[0]), new W3CError("unsupported operation", UnsupportedCommandException::new, 500, (WebDriverException[])new UnsupportedCommandException[0]), new W3CError("unknown command", UnsupportedCommandException::new, 404, (WebDriverException[])new UnsupportedCommandException[0]), new W3CError("unknown method", UnsupportedCommandException::new, 405, (WebDriverException[])new UnsupportedCommandException[0]), DEFAULT_ERROR);

    private ErrorCodec() {
    }

    public static ErrorCodec createDefault() {
        return new ErrorCodec();
    }

    public Map<String, Object> encode(Throwable throwable) {
        String text;
        Require.nonNull((String)"Throwable to encode", (Object)throwable);
        W3CError<? extends WebDriverException> err = this.fromThrowable(throwable);
        String message = throwable.getMessage() == null ? "<no message present in throwable>" : throwable.getMessage();
        StringWriter stacktrace = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stacktrace);){
            throwable.printStackTrace(printWriter);
        }
        if (throwable instanceof UnhandledAlertException && (text = ((UnhandledAlertException)throwable).getAlertText()) != null) {
            return Map.of("value", Map.of("error", err.w3cErrorString, "message", message, "stacktrace", stacktrace.toString(), "data", Map.of("text", text)));
        }
        return Map.of("value", Map.of("error", err.w3cErrorString, "message", message, "stacktrace", stacktrace.toString()));
    }

    public int getHttpStatusCode(Throwable throwable) {
        Require.nonNull((String)"Throwable to encode", (Object)throwable);
        return this.fromThrowable((Throwable)throwable).httpErrorCode;
    }

    public WebDriverException decode(Map<String, Object> response) {
        if (!(response.get("value") instanceof Map)) {
            throw new InvalidResponseException("missing \"value\" field", response);
        }
        Map value = (Map)response.get("value");
        String error = Objects.requireNonNullElse(value.get("error"), "");
        Object message = Objects.requireNonNullElseGet(value.get("message"), (Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/Object;)(response));
        if (!(error instanceof String)) {
            throw new InvalidResponseException("\"error\" field must be a string", response);
        }
        if (!(message instanceof String)) {
            throw new InvalidResponseException("\"message\" field must be a string", response);
        }
        Optional<W3CError> w3CError = ERRORS.stream().filter(err -> error.equals(err.w3cErrorString)).findFirst();
        if (w3CError.isPresent()) {
            return (WebDriverException)w3CError.get().exceptionConstructor.apply((String)message);
        }
        String extendedMessage = String.format("%s (error code: \"%s\")", message, error);
        return (WebDriverException)ErrorCodec.DEFAULT_ERROR.exceptionConstructor.apply(extendedMessage);
    }

    private W3CError<? extends WebDriverException> fromThrowable(Throwable throwable) {
        return ERRORS.stream().filter(err -> err.exception.isAssignableFrom(throwable.getClass())).findFirst().orElse(DEFAULT_ERROR);
    }

    private static class W3CError<T extends WebDriverException> {
        private final String w3cErrorString;
        private final Function<String, T> exceptionConstructor;
        private final Class<T> exception;
        private final int httpErrorCode;

        @SafeVarargs
        public W3CError(String w3cErrorString, Function<String, T> exceptionConstructor, int httpErrorCode, T ... reified) {
            this.w3cErrorString = w3cErrorString;
            this.exceptionConstructor = exceptionConstructor;
            this.exception = reified.getClass().getComponentType();
            this.httpErrorCode = httpErrorCode;
        }
    }
}

