/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.seleniumemulation;

import java.util.regex.Pattern;
import org.openqa.selenium.internal.seleniumemulation.ScriptMutator;

public class SeleniumMutator
implements ScriptMutator {
    private final Pattern pattern;
    private final String method;
    private final String atom;

    public SeleniumMutator(String method, String atom) {
        String raw = ".*" + method.replace(".", "\\s*\\.\\s*") + ".*";
        this.pattern = Pattern.compile(raw);
        this.method = method;
        this.atom = atom;
    }

    @Override
    public void mutate(String script, StringBuilder appendTo) {
        if (!this.pattern.matcher(script).matches()) {
            return;
        }
        appendTo.append(String.format("%s = function() { return (%s).apply(null, arguments);};", this.method, this.atom));
    }
}

