/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.seleniumemulation;

import com.thoughtworks.selenium.SeleniumException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.seleniumemulation.ElementFinder;
import org.openqa.selenium.internal.seleniumemulation.JavascriptLibrary;
import org.openqa.selenium.internal.seleniumemulation.SeleneseCommand;

public class GetTable
extends SeleneseCommand<String> {
    private static final Pattern TABLE_PARTS = Pattern.compile("(.*)\\.(\\d+)\\.(\\d+)");
    private final ElementFinder finder;
    private final JavascriptLibrary js;

    public GetTable(ElementFinder finder, JavascriptLibrary js) {
        this.finder = finder;
        this.js = js;
    }

    @Override
    protected String handleSeleneseCommand(WebDriver driver, String tableCellAddress, String ignored) {
        Matcher matcher = TABLE_PARTS.matcher(tableCellAddress);
        if (!matcher.matches()) {
            throw new SeleniumException("Invalid target format. Correct format is tableName.rowNum.columnNum");
        }
        String tableName = matcher.group(1);
        long row = Long.parseLong(matcher.group(2));
        long col = Long.parseLong(matcher.group(3));
        WebElement table = this.finder.findElement(driver, tableName);
        String script = "var table = arguments[0]; var row = arguments[1]; var col = arguments[2];if (row > table.rows.length) { return \"Cannot access row \" + row + \" - table has \" + table.rows.length + \" rows\"; }if (col > table.rows[row].cells.length) { return \"Cannot access column \" + col + \" - table row has \" + table.rows[row].cells.length + \" columns\"; }return table.rows[row].cells[col];";
        Object value = this.js.executeScript(driver, script, table, row, col);
        if (value instanceof WebElement) {
            return ((WebElement)value).getText().trim();
        }
        throw new SeleniumException((String)value);
    }
}

